package com.github.wxiaoqi.security.admin.biz;

import com.github.wxiaoqi.security.admin.entity.AppUserAlipay;
import com.github.wxiaoqi.security.admin.entity.AppUserRelationTemp;
import com.github.wxiaoqi.security.admin.mapper.AppUserAlipayMapper;
import com.github.wxiaoqi.security.admin.mapper.AppUserRelationTempMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

/**
 * 支付宝账号表
 *
 * @author libin
 * @email 18178966185@163.com
 * @date 2019-07-03 16:36:44
 */
@Service
public class AppUserAlipayBiz extends BaseBiz<AppUserAlipayMapper, AppUserAlipay> {

    //添加支付宝账号
    public  void  addAlipay(Integer userId,String txAlipay){
        AppUserAlipay appUserAlipay=new AppUserAlipay();
        appUserAlipay.setTxAlipay(txAlipay);
        appUserAlipay.setUserId(userId);
        appUserAlipay.setIsDel(0);
        AppUserAlipay appUserAlipay1=selectOne(appUserAlipay);
        if (appUserAlipay1==null){
            appUserAlipay.setIsDefault(1);
            insertSelective(appUserAlipay);
        }else {
            appUserAlipay1.setIsDefault(1);
            updateSelectiveById(appUserAlipay1);
        }
    }
   //获取支付宝列表
    public List<AppUserAlipay> getListByUserId(Integer userId){
        Example example=new Example(AppUserAlipay.class);
        example.createCriteria().andEqualTo("userId",userId).andEqualTo("isDel",0);
        example.setOrderByClause("is_default desc");
        return  selectByExample(example);
    }


}