package com.github.wxiaoqi.security.admin.mapper;

import com.github.wxiaoqi.security.admin.entity.BaseMemberLevel;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import tk.mybatis.mapper.common.Mapper;

import java.math.BigDecimal;
import java.util.List;

/**
 * 会员等级设置
 * 
 * @author hezhen
 * @email 18178966185@163.com
 * @date 2020-06-24 09:12:21
 */
public interface BaseMemberLevelMapper extends Mapper<BaseMemberLevel> {

    @Select("select max(`level`) from `base_member_level` where `is_del`=0 ")
    Integer selectMaxLevel();

    @Update("update `base_member_level` set `level`=`level`-1 where `is_del`=0  and `level`>#{level}")
    int updateUserMemberLevel(@Param("level") Integer level);

    @Select("select * from `base_member_level` as `buml` where  buml.`level`=#{level} and buml.is_del=0")
    BaseMemberLevel selectByLevel(@Param("level") Integer changeLevel);


    @Select("select * from `base_member_level` as `buml` where  buml.`level`> #{level} and buml.`money` <=  #{money} and buml.is_del=0  ORDER BY  buml.`level` DESC LIMIT 1 ")
    BaseMemberLevel getNextLevel(@Param("money") BigDecimal money, @Param("level") Integer Level);

    @Select("SELECT * FROM base_member_level WHERE is_del = 0 AND `level`  >= \n" +
            "(SELECT `level` FROM base_member_level WHERE id=#{levelId}  LIMIT 1 ) ORDER BY `level` ASC")
    List<BaseMemberLevel> getListByLevelId(@Param("levelId") Integer levelId);

}
