package com.xxfc.platform.universal.biz;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayConstants;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.domain.AlipayTradeAppPayModel;
import com.alipay.api.internal.util.AlipaySignature;
import com.alipay.api.request.AlipayFundAuthOrderFreezeRequest;
import com.alipay.api.request.AlipayTradeAppPayRequest;
import com.alipay.api.response.AlipayFundAuthOrderFreezeResponse;
import com.alipay.api.response.AlipayTradeAppPayResponse;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.HTTPSUtils;
import com.github.wxiaoqi.security.common.util.OrderUtil;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.util.process.SystemConfig;
import com.github.wxiaoqi.security.common.util.result.JsonResultUtil;
import com.xxfc.platform.universal.entity.Dictionary;
import com.xxfc.platform.universal.vo.OrderPayVo;
import com.xxfc.platform.universal.weixin.api.WXPay;
import com.xxfc.platform.universal.weixin.util.HTTPUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.xxfc.platform.universal.entity.OrderPay;
import com.xxfc.platform.universal.mapper.OrderPayMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import tk.mybatis.mapper.entity.Example;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import static com.xxfc.platform.universal.constant.DictionaryKey.PAY_DEMOTION;
import static com.xxfc.platform.universal.constant.DictionaryKey.UNIVERSAL_PAY;

/**
 * 订单支付
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-28 16:17:42
 */
@Service
@Slf4j
public class OrderPayBiz extends BaseBiz<OrderPayMapper,OrderPay> {

    @Autowired
    DictionaryBiz dictionaryBiz;

    @Autowired
    HttpServletRequest request;

    public JSONObject preparepay( OrderPayVo orderPayVo) {
        if(null == orderPayVo) {
            log.error("-----参数为空-----------");
            return JsonResultUtil.createFailedResult(ResultCode.NULL_CODE, "参数为空");
        }
        if(orderPayVo.getAmount()==null||orderPayVo.getAmount()==0) {
            log.error("-----金额不为为0-----------");
            return JsonResultUtil.createFailedResult(ResultCode.NULL_CODE, "金额不为为0");
        }
        if(StringUtils.isBlank(orderPayVo.getOrderNo())) {
            log.error("-----订单不能为空-----------");
            return JsonResultUtil.createFailedResult(ResultCode.NULL_CODE, "订单不能为空");
        }
        String trade_no =  OrderUtil.GetOrderNumber("");
        String order_no=orderPayVo.getOrderNo();
        Integer amount=orderPayVo.getAmount();
        log.error("---下单---order_no====="+order_no+"--支付订单号--trade_no===="+trade_no+"--金额---amount===="+amount);
        //报名费回调路径

        //临时处理
        Map<String, Dictionary> dictionaryMap = dictionaryBiz.getAll4Map();
        Integer demotion = Integer.valueOf(dictionaryMap.get(UNIVERSAL_PAY+ "_"+ PAY_DEMOTION).getDetail());
        amount = amount/demotion;
        if(amount <= 0) {
            amount = 1;
        }
        Integer type=orderPayVo.getType();
        String jsParam="";
        String  notify_url="https://"+ SystemConfig.weixinHost+"/api/universal/pay/app/unauth/notify";
        if(type!=null&&type==2){
            jsParam=WXPay.webPay( amount+"",orderPayVo.getBody(),notify_url,trade_no,orderPayVo.getBuyerIp(), orderPayVo.getBuyerAccount());
        }else {
            jsParam = WXPay.apppay(amount+"",orderPayVo.getBody(),notify_url ,trade_no,orderPayVo.getBuyerIp(),0);
        }
        log.info("报名费回调路径jsParam:"+jsParam);
        if(!StringUtils.isBlank(jsParam))
        {
            try {
                OrderPay orderPay= new OrderPay();
                BeanUtils.copyProperties(orderPay,orderPayVo);
                orderPay.setTradeNo(trade_no);
                orderPay.setSellerAccount(SystemConfig.APP_PARTNER);
                insertSelective(orderPay);
                log.error("---下单---order_no====="+order_no+"----成功");
            } catch (Exception e) {
                e.printStackTrace();
                log.error("---下单---order_no====="+order_no+"----异常---msg==="+ e.getMessage());
                return JsonResultUtil.createFailedResult(ResultCode.EXCEPTION_CODE, "出现异常");
            }
             JSONObject temp = JSON.parseObject(jsParam);
            return JsonResultUtil.createSuccessResultWithObj(temp);
        }else{
            return JsonResultUtil.createDefaultFail();
        }
    }
    //支付回调
    public void notice(String orderNo,String serialNumber){
        log.error("---支付回调---trade_no====="+orderNo+"----开始处理");
        Example example =new Example(OrderPay.class);
        example.createCriteria().andEqualTo("tradeNo", orderNo).andEqualTo("isDel",0).andEqualTo("status",0);
        List<OrderPay> list=mapper.selectByExample(example);
        if(list.size()==0){
            log.error("---支付回调---trade_no====="+orderNo+"----订单不存在或已处理");
             return;
        }
        example.clear();
        example.createCriteria().andEqualTo("tradeNo",orderNo);
        OrderPay orderPay=new OrderPay();
        orderPay.setFinishTime(System.currentTimeMillis());
        orderPay.setStatus(1);
        orderPay.setSerialNumber(serialNumber);
        int num=mapper.updateByExampleSelective(orderPay,example);
        log.error("---支付回调处理---num====="+num+"----orderNo======="+orderNo);
        if(num>0){
            OrderPay pay= list.get(0);
            if(StringUtils.isNotBlank(pay.getNotifyUrl())){
                String url=pay.getNotifyUrl();
                Integer type=pay.getType()==null?1:pay.getType();
                url+="&tradeNo="+orderNo+"&type="+type;
                log.error("---支付回调处理---orderNo======="+orderNo+"----notifyUrl===="+url);
                String result="";
                if(url.contains("https")||url.contains("HTTPS")){
                     result= HTTPSUtils.httpRequest(url, "GET",null);
                }else{
                    result= HTTPUtils.doGet(url);
                }
                log.error("---支付回调处理---orderNo======="+orderNo+"---result==="+result);
            }
        }
    }

    /**
     * 支付宝回调接口
     * @return
     */
    public String alipayNotify() {
        //获取支付宝POST过来反馈信息
        Map<String,String> params = new HashMap<>();
        Map requestParams = request.getParameterMap();
        for (Iterator iter = requestParams.keySet().iterator(); iter.hasNext();) {
            String name = (String) iter.next();
            String[] values = (String[]) requestParams.get(name);
            String valueStr = "";
            for (int i = 0; i < values.length; i++) {
                valueStr = (i == values.length - 1) ? valueStr + values[i]
                        : valueStr + values[i] + ",";
            }
            log.info(valueStr);
            //乱码解决，这段代码在出现乱码时使用。
            //valueStr = new String(valueStr.getBytes("ISO-8859-1"), "utf-8");
            params.put(name, valueStr);
        }
        String msg = JSONObject.toJSONString(params);
        log.info("alipay notify message={}", msg);
//		//添加回调记录
//		PaymentCallbackLog callbackLog = new PaymentCallbackLog();
//		callbackLog.setPayCode(rstradeNo);
//		callbackLog.setPayType(SystemConstant.PayType.ALIPAY);
//		callbackLog.setOrderCode(rsOrderCode);
//		callbackLog.setMessage(msg);
//		paymentCallbackLogRepository.save(callbackLog);
        //切记alipaypublickey是支付宝的公钥，请去open.alipay.com对应应用下查看。
        //boolean AlipaySignature.rsaCheckV1(Map<String, String> params, String publicKey, String charset, String sign_type)
        try {
            boolean flag = AlipaySignature.rsaCheckV1(params, "", AlipayConstants.CHARSET_UTF8, AlipayConstants.SIGN_TYPE_RSA2);
            if (!flag) {
                log.info("alipay order rsaCheckV1 fail, result={}", msg);
                return ObjectRestResponse.createDefaultFail().getMessage();
            }
            String rsTradeStatus = params.get("trade_status");
            if (!SystemConfig.ALIPAY_TRADE_FINISHED.equals(rsTradeStatus) && !SystemConfig.ALIPAY_TRADE_SUCCESS.equals(rsTradeStatus)) {
                log.info("alipay order trade_status has problem, result={}", msg);
                return ObjectRestResponse.createDefaultFail().getMessage();
            }
            //String rsSellerId = params.get("seller_id");
//
//			PaymentRecord paymentRecord = paymentRecordRepository.findOneByOrderCode(rsOrderCode);
//			//验证付款信息
//			if (paymentRecord == null || !paymentRecord.getAmount().toString().equals(rsAmount)
//					|| !aliPayConfig.getAppId().equals(rsAppId)) {
//				log.info("alipay order notify fail, result={}", msg);
//				return Response.FAILURE.getHeader().getMessage();
//			}
//			//重复回调
//			if (paymentRecord.getStatus().intValue() != 1) {
//				log.info("alipay order repeat notify, result={}", msg);
//				return Response.SUCCESS().getHeader().getMessage();
//			}
//
//			paymentRecord.setPayCode(rstradeNo);
//			paymentRecord.setStatus(2);
//			paymentRecordRepository.save(paymentRecord);

//			Map<String, Object> sendMap =  DataUtils.objectToMap(paymentRecord);
//			sendMap.put("amount", new BigDecimal(rsAmount).multiply(new BigDecimal(100)).intValue());
//			sendMsgToOrder(JSONObject.toJSONString(sendMap));
            return ObjectRestResponse.succ().getMessage();
        } catch (AlipayApiException e) {
            log.error("", e);
        }
        return ObjectRestResponse.createDefaultFail().getMessage();
    }

    /**
     * 支付宝生成支付信息
     * @param orderCode
     * @param description
     * @param payType
     * @param amount
     * @return
     */
    @SuppressWarnings("rawtypes")
    private ObjectRestResponse generateAliPayment(String orderCode, String description, String payType, Integer amount
                                       ) {
        BigDecimal realAmount = new BigDecimal(amount.toString()).divide(new BigDecimal("100"), 2, BigDecimal.ROUND_UP);
        String notifyUrl =SystemConfig.weixinHost + "/service/payment/notify/alipay";

        //实例化客户端
        AlipayClient alipayClient = new DefaultAlipayClient(SystemConfig.ALIPAY_PAY_BASE_URL + "/gateway.do",
                SystemConfig.ALIPAY_APPID, SystemConfig.ALIPAY_PRIVATE_KEY, AlipayConstants.FORMAT_JSON,
                AlipayConstants.CHARSET_UTF8, SystemConfig.ALIPAY_PUBLIC_KEY, AlipayConstants.SIGN_TYPE_RSA2);

        //实例化具体API对应的request类,类名称和接口名称对应,当前调用接口名称：alipay.trade.app.pay
		AlipayTradeAppPayRequest request = new AlipayTradeAppPayRequest();
//		//SDK已经封装掉了公共参数，这里只需要传入业务参数。以下方法为sdk的model入参方式(model和biz_content同时存在的情况下取biz_content)。
		AlipayTradeAppPayModel model = new AlipayTradeAppPayModel();
		//model.setBody("我是测试数据");
		model.setSubject(description);
		model.setOutTradeNo(orderCode);
		model.setTimeoutExpress("30m");
		model.setTotalAmount(realAmount.toString());
		model.setProductCode("QUICK_MSECURITY_PAY");
		request.setBizModel(model);
		request.setNotifyUrl(notifyUrl);

//        AlipayFundAuthOrderFreezeRequest request = new AlipayFundAuthOrderFreezeRequest();
//        String contentString = "{" +
//                "\"auth_code\":\"" + orderCode + "\"," +
//                "\"auth_code_type\":\"bar_code\"," +
//                "\"out_order_no\":\"8077735255938023\"," +
//                "\"out_request_no\":\"8077735255938032\"," +
//                "\"order_title\":\"预授权冻结\"," +
//                "\"amount\":0.01," +
//                "\"payee_logon_id\":\"" + SystemConfig.ALIPAY_ACOUNT + "\"," +
//                "\"payee_user_id\":\"" + SystemConfig.ALIPAY_PID + "\"," +
//                "\"pay_timeout\":\"2d\"," +
//                "\"extra_param\":\"{\\\"secondaryMerchantId\\\":\\\"17320004886\\\"}\"," +
//                "\"product_code\":\"PRE_AUTH\"" ;
//        log.info("content = {}", contentString);
//        request.setBizContent(contentString);
//        AlipayFundAuthOrderFreezeResponse response;
//        try {
//            response = alipayClient.execute(request);
//            if(response.isSuccess()){
//                System.out.println("调用成功");
//                Map<String, Object> rt = new HashMap<>();
//                rt.put("payType", payType);
//                rt.put("payData", response.getBody());
//                return ObjectRestResponse.succ(rt);
//            } else {
//                System.out.println("调用失败");
//            }
//        } catch (AlipayApiException e) {
//            // TODO Auto-generated catch block
//            e.printStackTrace();
//        }


		try {
	        //这里和普通的接口调用不同，使用的是sdkExecute
	       AlipayTradeAppPayResponse response = alipayClient.sdkExecute(request);
	        System.out.println(response.getBody());//就是orderString 可以直接给客户端请求，无需再做处理。

	        log.info("alipay result={}", response.getMsg());
	        log.info("alipay result={}", response.getCode());
	        log.info("alipay result={}", response.getBody());

	        Map<String, Object> rt = new HashMap<>();
	    	rt.put("payType", payType);
	    	rt.put("payData", response.getBody());
	    	return ObjectRestResponse.succ(rt);
	    } catch (AlipayApiException e) {
	        e.printStackTrace();
		}
        return ObjectRestResponse.createDefaultFail();
    }

    public ObjectRestResponse generatePayment(String orderCode, String description, String payType, Integer amount
                                   ) {
       ObjectRestResponse objectRestResponse = ObjectRestResponse.createDefaultFail();
        switch (payType) {
            case SystemConfig.ALIPAY:
                objectRestResponse = generateAliPayment(orderCode, description, payType, amount);
                break;
            default:
                log.info("不支持的付款类型，payType={}", payType);
                break;
        }
        return objectRestResponse;
    }



    public static void main(String[] args) {
        String url="https://xxtest.upyuns.com/api/order/baseOrder/app/unauth/notifyUrl?orderNo=20190603141137010007&tradeNo=20190603141137000002";
        String result="";
        if(url.contains("https")||url.contains("HTTPS")){
            result= HTTPSUtils.httpRequest(url, "GET",null);
        }else{
            result= HTTPUtils.doGet(url);
        }
        System.out.println(result);
    }
}