package com.xxfc.platform.tour.rest;

import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.tour.biz.TourUserBiz;
import com.xxfc.platform.tour.common.TourBaseController;
import com.xxfc.platform.tour.entity.TourUser;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.web.bind.annotation.*;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.weekend.WeekendSqls;

import java.util.Arrays;
import java.util.List;

@RestController
@RequestMapping("tourUser")
public class TourUserController extends TourBaseController<TourUserBiz> {

    @Autowired
    private TourUserBiz tourUserBiz;


    /**
     * 获取全部成人或儿童
     * @param isChild 0-儿童 1-成年人
     * @return
     */
    @GetMapping("/app/unauth/getTourUser/{isChild}")
    public ObjectRestResponse findListByTourUserByIsChild(@PathVariable int isChild){
        AppUserDTO userInfo = getUserInfo();
        Integer id = userInfo.getUserid();
        List<TourUser> tourUsers= baseBiz.findListByTourUserByIsChild(id,isChild);

       return ObjectRestResponse.succ(tourUsers);
    }


    @GetMapping("/app/unauth/getTourUsers")
    public ObjectRestResponse<List<TourUser>> getTourUsers(@ApiParam(name = "ids") String ids){
        List<TourUser> tourUsers= tourUserBiz.selectByExample(new Example.Builder(TourUser.class)
                .where(WeekendSqls.<TourUser>custom()
                .andIn(TourUser::getId, Arrays.asList(ids.split(",")))
                ).build());
        return ObjectRestResponse.succ(tourUsers);
    }


    /**
     * 添加和更新
     * @param tourUser
     * @return
     */

    @ApiOperation("插入和更新")
    @PostMapping(value = "/app/addAndUpdate")
    @Transactional
    public ObjectRestResponse<TourUser> addAndUpdate(@RequestBody TourUser tourUser){
        try {
            if (tourUser.getId()==null||tourUser.getId()==0) {
                AppUserDTO userInfo = getUserInfo();
                if (userInfo==null||userInfo.getUserid()==null||userInfo.getUserid()==0) {
                   return  ObjectRestResponse.createDefaultFail();
                }
                Integer userid = userInfo.getUserid();
                TourUser tourUser1=new  TourUser();
                tourUser1.setUserid(userid);
                tourUser1.setIdCard(tourUser.getIdCard());
                tourUser1=baseBiz.selectOne(tourUser1);
                if(tourUser1!=null){
                    return  ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE,"出游人证件号一样");
                }
                tourUser.setUserid(userid);
                tourUser.setCrtTime(System.currentTimeMillis());
                tourUser.setIsdel(0);
                baseBiz.insertSelective(tourUser);
            }else {
                tourUser.setUpdTime(System.currentTimeMillis());
                baseBiz.updateSelectiveById(tourUser);
            }
            return new ObjectRestResponse<TourUser>();
        } catch (Exception e) {
            e.printStackTrace();
            throw new BaseException(ResultCode.FAILED_CODE);
        }


    }

    /**
     * 删除
     * @param
     * @return
     */

    @ApiOperation("删除")
    @PostMapping(value = "/app/del")
    @Transactional(rollbackFor = Exception.class)
    public ObjectRestResponse<TourUser> del(@RequestBody TourUser tourUser){
        try {

            tourUser.setIsdel(1);
                baseBiz.updateSelectiveById(tourUser);
            return ObjectRestResponse.succ();
        } catch (Exception e) {
            e.printStackTrace();
            throw new BaseException(ResultCode.FAILED_CODE);
        }
    }

    @ApiOperation("通过id查询")
    @GetMapping(value = "/app/findById/{id}")
    public ObjectRestResponse<TourUser> findById(@PathVariable Integer id){

        AppUserDTO userInfo = getUserInfo();
        if (userInfo==null||userInfo.getUserid()==null||userInfo.getUserid()==0) {
            ObjectRestResponse.createDefaultFail();
        }
        Integer userid = userInfo.getUserid();
        TourUser user = new TourUser();
        user.setUserid(userid);
        user.setId(id);
        if (id==null||id==0) {
            ObjectRestResponse.createDefaultFail();
        }
        return ObjectRestResponse.succ(baseBiz.selectList(user));
    }


    /**
     * 获取全部出游人信息
     * @return
     */
    @GetMapping("/app/unauth/getTourUserList")
    public ObjectRestResponse getTourUser(){
        AppUserDTO userInfo = getUserInfo();
        if (userInfo==null||userInfo.getUserid()==null||userInfo.getUserid()==0) {
            ObjectRestResponse.createDefaultFail();
        }
        Integer id = userInfo.getUserid();
        List<TourUser> tourUsers= baseBiz.getTourUser(id);
        return ObjectRestResponse.succ(tourUsers);
    }






}