package com.xxfc.platform.order.pojo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

@Data
public class AddRentVehicleDTO{
    public static final DateTimeFormatter DEFAULT_DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    //开始时间
    @ApiModelProperty(value = "开始时间")
    private Long startTime;

    //结束时间
    @ApiModelProperty(value = "结束时间")
    private Long endTime;

    /**
     * 预定目标日期(开始)
     */
    @ApiModelProperty(value = "预定目标日期(开始)", hidden = true)
    private String bookStartDate;

    /**
     * 预定目标日期(结束)
     */
    @ApiModelProperty(value = "预定目标日期(结束)", hidden = true)
    private String bookEndDate;

    //天数
    @ApiModelProperty(value = "天数")
    private Integer dayNum;

    //取车地点
    @ApiModelProperty(value = "取车地点")
    private String startAddr;

    //还车地点
    @Column(name = "end_addr")
    @ApiModelProperty(value = "还车地点")
    private String endAddr;

    //取车城市编号
    @ApiModelProperty(value = "取车城市编号")
    private Integer startCity;

    //还车城市编号
    @Column(name = "end_city")
    @ApiModelProperty(value = "还车城市编号")
    private Integer endCity;

    //取车城市名称
    @ApiModelProperty(value = "取车城市名称")
    private String startCityName;

    //还车城市名称
    @Column(name = "end_city_name")
    @ApiModelProperty(value = "还车城市名称")
    private String endCityName;

    //司机类型 1--公司司机；2--自己司机
    @ApiModelProperty(value = "司机类型 1--公司司机；2--自己司机")
    private Integer driverType;

    //自己司机ids
    @ApiModelProperty(value = "自己司机ids")
    private String myDriverIds;

    //出发公司Id
    @ApiModelProperty(value = "出发公司Id")
    private Integer startCompanyId;

    //结束公司Id
    @ApiModelProperty(value = "结束公司Id")
    private Integer endCompanyId;

    //车型id
    @ApiModelProperty(value = "车型id")
    private Integer modelId;

    //车型id
    @ApiModelProperty(value = "是否购买免赔")
    private Integer damageSafe;

    /**
     * 是否使用出租免费天数
     */
    @ApiModelProperty(value = "是否使用出租免费天数")
    private Integer rentFreeDay;

    /**
     *
     */
    @ApiModelProperty(value = "下单来源，1--app；2--小程序")
    private Integer orderOrigin;


    /**
     * 优惠券ids
     */
    @ApiModelProperty(value = "优惠券ids")
    private String couponIds;

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
        this.bookStartDate = DEFAULT_DATE_TIME_FORMATTER.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(startTime), ZoneOffset.ofHours(8)));
    }

    public void setEndTime(Long endTime) {
        this.endTime = endTime;
        this.bookEndDate = DEFAULT_DATE_TIME_FORMATTER.format(LocalDateTime.ofInstant(Instant.ofEpochMilli(endTime), ZoneOffset.ofHours(8)));
    }
}
