package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.AdminBootstrap;
import com.github.wxiaoqi.security.admin.biz.BaseUserMemberBiz;
import com.github.wxiaoqi.security.admin.biz.BaseUserMemberExportBiz;
import com.github.wxiaoqi.security.admin.dto.UserMemberDTO;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.excel.ExcelImport;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

/**
 * ${DESCRIPTION}
 *
 * @author wanghaobin
 * @create 2017-06-08 11:51
 */
@RestController
@RequestMapping("member")
public class UserMemberController {

    @Autowired
    private BaseUserMemberBiz memberBiz;

    @Autowired
    private BaseUserMemberExportBiz baseUserMemberExportBiz;

    /**
     * 购买会员
     *
     * @param userMemberDTO
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/user/buyMember", method = RequestMethod.POST)
    public ObjectRestResponse buyMember(@RequestBody UserMemberDTO userMemberDTO) throws Exception {
        memberBiz.updUserMemberByUserId(userMemberDTO);
        return ObjectRestResponse.succ();
    }

    /**
     * 订单更改会员
     *
     * @param userId
     * @param days
     * @param type   1-用户锁定下单；2-购买下单;3-取消订单
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "/user/memberDays", method = RequestMethod.POST)
    public int memberDays(
            @RequestParam(value = "userId", defaultValue = "0") Integer userId,
            @RequestParam(value = "days", defaultValue = "0") Integer days,
            @RequestParam(value = "type", defaultValue = "1") Integer type
    ) throws Exception {
        return memberBiz.upMemberDays(userId, days, type);
    }

    @PostMapping("/user/export")
    public ObjectRestResponse importUserMember(MultipartFile userMemberExcel) {
        List<String[]> userMemberData = ExcelImport.getExcelData(userMemberExcel);
        if (userMemberData.size() < 1) {
            return ObjectRestResponse.createFailedResult(1001, "导入不能没数据！！！");
        }
        for (String[] userMemberDatum : userMemberData) {
            if (userMemberDatum.length!=4){
                return ObjectRestResponse.createFailedResult(1002, "数据不完整！！！");
            }
        }
        userMemberData.remove(0);
        try {
            int effectSize = baseUserMemberExportBiz.importUserMember(userMemberData);
            return  ObjectRestResponse.succ(effectSize);
        }catch (BaseException ex){
         return  ObjectRestResponse.createDefaultFail();
        }
    }

    @GetMapping("/user/excel_model/dowload")
    public ResponseEntity<byte[]> dowloadUserMemberExcelModel(HttpServletResponse response){
        // 重置response
        response.reset();
        //设置http头信息的内容
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/vnd.ms-excel");
        response.addHeader("Content-Disposition", "attachment;filename=usermember.xlsx");
        InputStream inputStream = AdminBootstrap.class.getClassLoader().getResourceAsStream("file/usermember.xlsx");
        try {
            byte[] bytes = IOUtils.toByteArray(inputStream);
            return ResponseEntity.ok(bytes);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return ResponseEntity.status(HttpStatus.BAD_REQUEST).body(null);
    }
}
