package com.github.wxiaoqi.security.admin.biz;

import com.github.wxiaoqi.security.admin.dto.BaseUserMemberExportDTO;
import com.github.wxiaoqi.security.admin.dto.UserMemberDTO;
import com.github.wxiaoqi.security.admin.entity.BaseUserMemberExport;
import com.github.wxiaoqi.security.admin.mapper.BaseUserMemberExportMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.exception.BaseException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/7/8 16:19
 */
@Service
@Transactional
@Slf4j
public class BaseUserMemberExportBiz extends BaseBiz<BaseUserMemberExportMapper, BaseUserMemberExport> {

     @Autowired
     private UserMemberLevelBiz userMemberLevelBiz;

     @Autowired
     private BaseUserMemberBiz baseUserMemberBiz;

     @Autowired
     private  AppUserLoginBiz appUserLoginBiz;


    @Transactional(rollbackFor = Exception.class,propagation = Propagation.REQUIRED)
    public int importUserMember(List<String[]> userMemberData){
        List<BaseUserMemberExport> baseUserMemberExports = new ArrayList<>();

        List<Integer> levels = userMemberData.stream().map(x -> x[1]).map(Integer::valueOf).collect(Collectors.toList());
        Map<Integer, Integer> levelAndDisCountMap= userMemberLevelBiz.getUserMemberLevelAndDisCountMapByLevels(levels);
        List<String> phones = userMemberData.stream().map(x -> x[0]).collect(Collectors.toList());
        Map<String,Integer> phoneAndUserIdMap = appUserLoginBiz.findPhoneAndUserIdMapByPhones(phones);

        for (String[] data : userMemberData) {

            String phone = data[0];
            String memberLevel = data[1];
            String totalNumber = data[2];
            String rentFreeDays = data[3];

            if (phoneAndUserIdMap!=null && phoneAndUserIdMap.get(phone)!=null){
                UserMemberDTO userMemberDTO = new UserMemberDTO();
                userMemberDTO.setUserId(phoneAndUserIdMap.get(phone));
                userMemberDTO.setMemberLevel(Integer.valueOf(memberLevel));
                userMemberDTO.setDiscount(levelAndDisCountMap==null?0:(levelAndDisCountMap.get(Integer.valueOf(memberLevel))==null?0:levelAndDisCountMap.get(Integer.valueOf(memberLevel))));
                userMemberDTO.setTotalNumber(Integer.valueOf(totalNumber));
                userMemberDTO.setRentFreeDays(Integer.valueOf(rentFreeDays));
                userMemberDTO.setIsBind(1);
                try {
                    baseUserMemberBiz.updUserMemberByUserId(userMemberDTO);
                } catch (Exception e) {
                    log.error("会员更新错误：【{}】",e.getMessage());
                    throw new BaseException(e);
                }
            }

            BaseUserMemberExport memberExport = BaseUserMemberExport
                    .builder()
                    .username(phone)
                    .memberLevel(Integer.valueOf(memberLevel))
                    .totalNumber(Integer.valueOf(totalNumber))
                    .rentFreeDays(Integer.valueOf(rentFreeDays))
                    .discount(levelAndDisCountMap==null?0:(levelAndDisCountMap.get(Integer.valueOf(memberLevel))==null?0:levelAndDisCountMap.get(Integer.valueOf(memberLevel))))
                    .status(phoneAndUserIdMap == null ? 0 : (phoneAndUserIdMap.get(phone) == null ? 0 : 1))
                    .isDel(0)
                    .build();
             if (log.isDebugEnabled()){
                 log.debug("当前组装的数据：【{}】",memberExport);
             }
            baseUserMemberExports.add(memberExport);
        }

        InsertBatch(baseUserMemberExports);
        return baseUserMemberExports.size();
    }

    @Transactional(rollbackFor = Exception.class,propagation = Propagation.REQUIRED)
    public void InsertBatch(List<BaseUserMemberExport> baseUserMemberExports) {
        mapper.insertList(baseUserMemberExports);
    }

     public List<BaseUserMemberExportDTO> findUserMemberExportDataByPhoneAndHashEffective(String phone){
         List<BaseUserMemberExportDTO> baseUserMemberExportDTOS  = new ArrayList<>();

         Example example = new Example(BaseUserMemberExport.class);
         Example.Criteria criteria = example.createCriteria();
         criteria.andEqualTo("username",phone);
         criteria.andEqualTo("status",0);
         List<BaseUserMemberExport> baseUserMemberExports = mapper.selectByExample(example);

         if (CollectionUtils.isNotEmpty(baseUserMemberExports)){
                  BaseUserMemberExportDTO baseUserMemberExportDTO;
             for (BaseUserMemberExport userMemberExport : baseUserMemberExports) {
                 baseUserMemberExportDTO = new BaseUserMemberExportDTO();
                 BeanUtils.copyProperties(userMemberExport,baseUserMemberExportDTO);
                 baseUserMemberExportDTOS.add(baseUserMemberExportDTO);
             }
         }
         return baseUserMemberExportDTOS;
     }
    @Transactional(rollbackFor = Exception.class,propagation = Propagation.REQUIRED)
     public void updateUserMemberExportDataToLoseEfficacyByPhone(String phone){
        mapper.updateUserMemberExportDataToLoseEfficacyByPhone(phone);
     }
}
