package com.xxfc.platform.universal.controller;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.universal.biz.FastServiceBiz;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/fastService")
public class FastServiceController {

    @Autowired
    FastServiceBiz fastServiceBiz;

    /**
     * 获取用户授权token
     * @param code
     * @return
     */
    @GetMapping(value = "/app/unauth/getUserToken")
    public ObjectRestResponse getAccessToken(String code) {
        return fastServiceBiz.getAccessToken(code);
    }

    /**
     * 获取应用token
     * @return
     */
    @GetMapping(value = "/app/unauth/getApplicationToken")
    public ObjectRestResponse getAccessToken() {
        return fastServiceBiz.getAccessToken();
    }

    /**
     * 获取用户 openId
     * @param accessToken
     * @return
     */
    @GetMapping(value = "/app/unauth/openId")
    public ObjectRestResponse getOpenId(String accessToken) {
        return fastServiceBiz.getOpenId(accessToken);
    }

}
