package com.xxfc.platform.universal.biz;


import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.universal.fastservice.api.FastServiceApi;
import com.xxfc.platform.universal.fastservice.dto.RequestBodyDto;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class FastServiceBiz {

    @Autowired
    FastServiceApi fastServiceApi;

    /**
     * 获取用户授权token
     * @param code
     * @return
     */
    public ObjectRestResponse getAccessToken(String code) {
        String result = fastServiceApi.getAccessToken(code);
        return ObjectRestResponse.succ(result);
    }

    /**
     * 获取应用token
     * @return
     */
    public ObjectRestResponse getAccessToken() {
        String result = fastServiceApi.getAccessToken();
        return ObjectRestResponse.succ(result);
    }

    /**
     * 获取用户 openId
     * @param accessToken
     * @return
     */
    public ObjectRestResponse getOpenId(String accessToken) {
        String result = fastServiceApi.getOpenId(accessToken);
        return ObjectRestResponse.succ(result);
    }


}
