package com.xxfc.platform.uccn.rest.admin;

import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.uccn.biz.SummitActivityBiz;
import com.xxfc.platform.uccn.dto.SummitActivityFindDTO;
import com.xxfc.platform.uccn.dto.SummitActivitySaveDTO;
import com.xxfc.platform.uccn.vo.SummitActivityAdminVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author libin
 * @version 1.0
 * @description 
 * @data 2019/8/26 15:36
 */
@RestController
@RequestMapping("/admin/summitActivity")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
@Api("峰会活动*后台")
public class SummitActivityAdminController {

     private final  SummitActivityBiz summitActivityBiz;


     @ApiOperation("活动列表")
     @PostMapping("/list")
     public ObjectRestResponse<PageDataVO<SummitActivityAdminVo>> listSummitActivityWithPage(@RequestBody SummitActivityFindDTO summitActivityFindDTO){
         PageDataVO<SummitActivityAdminVo>  pageDataVO =  summitActivityBiz.listSummitActivityWithPage(summitActivityFindDTO);
          return ObjectRestResponse.succ(pageDataVO);
     }

     @ApiOperation("编辑查询")
     @GetMapping("/{id}")
     public ObjectRestResponse<SummitActivitySaveDTO>  selectToEdit(@PathVariable(value = "id") Integer id){
           SummitActivitySaveDTO summitActivitySaveDTO = summitActivityBiz.selectSummitActivityById(id);
           return ObjectRestResponse.succ(summitActivitySaveDTO);
     }

     @ApiOperation("保存或编辑")
     @PostMapping("/save")
     public ObjectRestResponse<Void>  saveSummitActivity(@RequestBody SummitActivitySaveDTO summitActivitySaveDTO, UserDTO userDTO){
             summitActivityBiz.saveSummitActivity(summitActivitySaveDTO,userDTO);
          return ObjectRestResponse.succ();
     }

     @ApiOperation("活动发布设置")
     @PutMapping("/publish/{id}/{state}")
     public ObjectRestResponse<Void> publishSummitActivity(@PathVariable(value = "id") Integer id,@PathVariable(value = "state") Integer state){
          summitActivityBiz.publishSummitActivityById(id,state);
          return ObjectRestResponse.succ();
     }

     @ApiOperation("上下架活动")
     @PutMapping("/soldout/{id}/{state}")
     public ObjectRestResponse<Void> soldOutSummitActivity(@PathVariable(value = "id") Integer id,@PathVariable(value = "state") Integer state){
          summitActivityBiz.soldOutSummitAcitivityById(id,state);
          return ObjectRestResponse.succ();
     }

     @ApiOperation("首页展示设置")
     @PutMapping("/home_page/{id}/{state}")
     public ObjectRestResponse<Void> setShowOnHomePage(@PathVariable(value = "id") Integer id,@PathVariable(value = "state") Integer state){
          summitActivityBiz.setShowOnHomePageById(id,state);
          return ObjectRestResponse.succ();
     }

     @ApiOperation("报名开关设置")
     @PutMapping("/reg_state/{id}/{state}")
     public ObjectRestResponse<Void> setRegStateWithSummitActivity(@PathVariable(value = "id") Integer id,@PathVariable(value = "state") Integer state){
          summitActivityBiz.setRegSateWithSummitActivityById(id,state);
          return ObjectRestResponse.succ();
     }

     @ApiOperation("更改排序")
     @PutMapping("/rank/{id}/{rank}")
     public ObjectRestResponse<Void> setSummitActivityRank(@PathVariable(value = "id") Integer id,@PathVariable("rank") Integer rank){
          summitActivityBiz.updateSummitActivityRankById(id,rank);
          return ObjectRestResponse.succ();
     }

     @ApiOperation("删除活动")
     @DeleteMapping("/{id}")
     public ObjectRestResponse<Void> deleteSummitActivity(@PathVariable(value = "id") Integer id){
          summitActivityBiz.deleteSummitActivityById(id);
          return ObjectRestResponse.succ();
     }
}