package com.xxfc.platform.order.biz.inner;

import cn.hutool.core.date.DateUtil;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.admin.feign.dto.AppUserDTO;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.app.entity.Cofig;
import com.xxfc.platform.app.feign.ConfigFeign;
import com.xxfc.platform.order.biz.OrderAccountBiz;
import com.xxfc.platform.order.biz.OrderRefundBiz;
import com.xxfc.platform.order.contant.enumerate.AccountTypeEnum;
import com.xxfc.platform.order.contant.enumerate.OrderTypeEnum;
import com.xxfc.platform.order.contant.enumerate.RefundStatusEnum;
import com.xxfc.platform.order.contant.enumerate.RefundTypeEnum;
import com.xxfc.platform.order.entity.*;
import com.xxfc.platform.universal.constant.DictionaryKey;
import com.xxfc.platform.universal.dto.SmsTemplateDTO;
import com.xxfc.platform.universal.entity.Dictionary;
import com.xxfc.platform.universal.feign.ThirdFeign;
import com.xxfc.platform.vehicle.entity.BranchCompany;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import com.xxfc.platform.vehicle.pojo.CompanyDetail;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

import static com.github.wxiaoqi.security.admin.constant.enumerate.MemberEnum.NONE;
import static com.github.wxiaoqi.security.common.constant.CommonConstants.*;
import static com.xxfc.platform.universal.constant.DictionaryKey.APP_ORDER;

/**
 * 订单退款记录表
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-18 11:08:09
 */
@Slf4j
@Service
public class OrderMsgBiz {

    //客户通知
    public static final int RENT_PAY = 1;
    public static final int RENT_DELIVERY = 2;
    public static final int RENT_CANCEL = 3;

    //参数
    public static final String USER_N = "尊敬的客户";
    public static final String USER_M = "尊贵的会员";


    @Autowired
    UserFeign userFeign;

    @Autowired
    ThirdFeign thirdFeign;

    @Autowired
    VehicleFeign vehicleFeign;

    @Autowired
    ConfigFeign configFeign;

    @Autowired
    OrderRefundBiz orderRefundBiz;

    @Autowired
    OrderAccountBiz orderAccountBiz;

    /**
     * 处理App用户提醒短信的发送
     * @param orvd
     * @param omd
     * @param baseOrder
     * @param appUserDTO
     */
    public void handelAppUserMsg(OrderRentVehicleDetail orvd, OrderMemberDetail omd, BaseOrder baseOrder, AppUserDTO appUserDTO) {
        try {
            OrderTypeEnum orderTypeEnum = OrderTypeEnum.codeAndDesc.get(baseOrder.getType());
            Integer smstype;
            List<String> smsParams = new ArrayList<String>();
            smsParams.add(baseOrder.getRealAmount().toString());
            switch (orderTypeEnum) {
                case RENT_VEHICLE:
                    if(orvd.getFreeDays() > 0) {
                        smstype = SmsTemplateDTO.RENT_MEMENT;
                        smsParams.add(orvd.getFreeDays().toString());
                        smsParams.add(appUserDTO.getRentFreeDays().toString());
                    }else {
                        smstype = SmsTemplateDTO.RENT_NORMAL;
                    }
                    thirdFeign.sendTemplate(new SmsTemplateDTO(){{
                        setPhoneNumbers(appUserDTO.getUsername());
                        setType(smstype);
                        setParams(smsParams.toArray(new String[smsParams.size()]));
                    }});
                    break;
                case TOUR:
                    thirdFeign.sendTemplate(new SmsTemplateDTO(){{
                        setPhoneNumbers(appUserDTO.getUsername());
                        setType(SmsTemplateDTO.TOUR);
                        setParams(smsParams.toArray(new String[smsParams.size()]));
                    }});
                    break;
                case MEMBER:
                    smsParams.add(omd.getRentFreeNum().toString());
                    smsParams.add(appUserDTO.getRentFreeDays().toString());
                    thirdFeign.sendTemplate(new SmsTemplateDTO(){{
                        setPhoneNumbers(appUserDTO.getUsername());
                        setType(SmsTemplateDTO.MEMENT);
                        setParams(smsParams.toArray(new String[smsParams.size()]));
                    }});
                    break;
                default:
                    break;
            }
        }catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    /**
     * 处理后台用户提醒短信的发送
     * @param orvd
     * @param baseOrder
     * @param appUserDTO
     */
    public void handelBgUserMsg4Pay(OrderRentVehicleDetail orvd, BaseOrder baseOrder, AppUserDTO appUserDTO, Integer handelType) {
        try {
            OrderTypeEnum orderTypeEnum = OrderTypeEnum.codeAndDesc.get(baseOrder.getType());
            Integer smstype;
            List<String> smsParams = new ArrayList<String>();
            switch (orderTypeEnum) {
                case RENT_VEHICLE:
                    switch (handelType) {
                        case RENT_PAY:
                            //如果公司相同
                            if(null != orvd.getStartCompanyId() && !SYS_FALSE.equals(orvd.getStartCompanyId())) {
                                CompanyDetail companyDetail = vehicleFeign.getCompanyDetail(orvd.getStartCompanyId()).getData();
                                if(orvd.getStartCompanyId().equals(orvd.getEndCompanyId())) {
                                    smstype = SmsTemplateDTO.TAAKE_CAR;
                                }else {
                                    smstype = SmsTemplateDTO.DIFFERENT_TAAKE_CAR;
                                }
                                handelSmsParam(orvd, baseOrder, smsParams, appUserDTO, RENT_PAY);
                                SmsTemplateDTO smsTemplateDTO = new SmsTemplateDTO(){{
                                    setPhoneNumbers(companyDetail.getVehiceServicePhone());
                                    setType(smstype);
                                    setParams(smsParams.toArray(new String[smsParams.size()]));
                                }};
                                thirdFeign.sendTemplate(smsTemplateDTO);
                            }else {
                                log.error("通知后台客户短信异常，开始公司id 不存在或者为0 订单号：{}", baseOrder.getId());
                            }
                            break;
                        case RENT_DELIVERY:
                            //如果公司相同
                            if(null != orvd.getEndCompanyId() && !SYS_FALSE.equals(orvd.getEndCompanyId())) {
                                CompanyDetail companyDetail = vehicleFeign.getCompanyDetail(orvd.getEndCompanyId()).getData();
                                //不相同发送，相同不用发送
                                if(!orvd.getEndCompanyId().equals(orvd.getStartCompanyId())) {
                                    handelSmsParam(orvd, baseOrder, smsParams, appUserDTO, RENT_DELIVERY);
                                    thirdFeign.sendTemplate(new SmsTemplateDTO(){{
                                        setPhoneNumbers(companyDetail.getVehiceServicePhone());
                                        setType(SmsTemplateDTO.ALSO_CAR);
                                        setParams(smsParams.toArray(new String[smsParams.size()]));
                                    }});
                                }
                            }else {
                                log.error("通知后台客户短信异常，结束公司id 不存在或者为0 订单号：{}", baseOrder.getId());
                            }
                            break;
                        case RENT_CANCEL:
                            if(null != orvd.getEndCompanyId() && !SYS_FALSE.equals(orvd.getEndCompanyId())) {
                                handelSmsParam(orvd, baseOrder, smsParams, appUserDTO, RENT_CANCEL);
                                CompanyDetail companyDetail2 = vehicleFeign.getCompanyDetail(orvd.getEndCompanyId()).getData();
                                SmsTemplateDTO smsTemplateDTO = new SmsTemplateDTO();
                                smsTemplateDTO.setPhoneNumbers(companyDetail2.getVehiceServicePhone());
                                smsTemplateDTO.setType(Integer.valueOf(SmsTemplateDTO.CANCEL));
                                List<String> smsParams2 = smsParams;
                                smsTemplateDTO.setParams(smsParams2.toArray(new String[smsParams2.size()]));
                                thirdFeign.sendTemplate(smsTemplateDTO);
                            }else {
                                log.error("通知后台客户短信异常，结束公司id 不存在或者为0 订单号：{}", baseOrder.getId());
                            }
                            break;
                        default:
                            break;
                    }
                    break;
                default:
                    break;
            }
        }catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    /**
     * 支付订单处理提醒短信的发送
     * @param orvd
     * @param baseOrder
     * @param appUserDTO
     */
    public void handelMsgPayNew(OrderRentVehicleDetail orvd, OrderTourDetail otd, OrderMemberDetail omd, BaseOrder baseOrder, AppUserDTO appUserDTO) {
        try {
            OrderTypeEnum orderTypeEnum = OrderTypeEnum.codeAndDesc.get(baseOrder.getType());
            Integer smstype;
            List<String> smsParams = new ArrayList<String>();
            switch (orderTypeEnum) {
                case RENT_VEHICLE:
                    CompanyDetail startCompanyDetail = vehicleFeign.getCompanyDetail(orvd.getStartCompanyId()).getData();
                    CompanyDetail endCompanyDetail = vehicleFeign.getCompanyDetail(orvd.getEndCompanyId()).getData();
                    if(null != orvd.getStartCompanyId() && !SYS_FALSE.equals(orvd.getStartCompanyId())) {
                        //使用免费天数
                        if(null != orvd.getFreeDays() && orvd.getFreeDays() > 0) {
                            smstype = SmsTemplateDTO.PAY_B;
                        }else {
                            smstype = SmsTemplateDTO.PAY_A;
                        }
                        sms2AppUser(startCompanyDetail, endCompanyDetail, orvd, otd, omd, baseOrder, appUserDTO, smstype, smsParams);

                        //后台发送消息(客服)
                        Cofig cofig = configFeign.getAllByType(ConfigFeign.TYPE_CUS_SER+ "").getData().get(0);
                        smsParams.clear();
                        sms2BgUser(cofig.getValue(), startCompanyDetail, endCompanyDetail, orvd, otd, baseOrder, appUserDTO, SmsTemplateDTO.PAY_C, smsParams);

                        //后台发送消息(出车人)
                        smsParams.clear();
                        sms2BgUser(startCompanyDetail.getVehiceServicePhone(), startCompanyDetail, endCompanyDetail, orvd, otd, baseOrder, appUserDTO, SmsTemplateDTO.PAY_D, smsParams);

                        //后台发送消息(收车人)
                        smsParams.clear();
                        sms2BgUser(endCompanyDetail.getVehiceServicePhone(), startCompanyDetail, endCompanyDetail, orvd, otd, baseOrder, appUserDTO, SmsTemplateDTO.PAY_E, smsParams);

                    }else {
                        log.error("通知短信异常，开始公司id 不存在或者为0 订单号：{}", baseOrder.getId());
                    }
                    break;
                case TOUR:
                    CompanyDetail startCompanyDetailTour = vehicleFeign.getCompanyDetail(otd.getStartCompanyId()).getData();
                    //发送短信给app用户
                    sms2AppUser(startCompanyDetailTour, null, orvd, otd, omd, baseOrder, appUserDTO, SmsTemplateDTO.PAY_F, smsParams);

                    //后台发送消息(客服)
                    Cofig cofig = configFeign.getAllByType(ConfigFeign.TYPE_CUS_SER+ "").getData().get(0);
                    smsParams.clear();
                    sms2BgUser(cofig.getValue(), startCompanyDetailTour, null, orvd, otd, baseOrder, appUserDTO, SmsTemplateDTO.PAY_H, smsParams);

                    break;
                case MEMBER:
                    sms2AppUser(null, null, orvd, otd, omd, baseOrder, appUserDTO, SmsTemplateDTO.PAY_G, smsParams);
                    break;
                default:
                    break;
            }
        }catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    /**
     * 取消订单处理提醒短信的发送
     * @param orvd
     * @param baseOrder
     * @param appUserDTO
     */
    public void handelMsgCancel(OrderRentVehicleDetail orvd, OrderTourDetail otd, OrderMemberDetail omd, BaseOrder baseOrder, AppUserDTO appUserDTO) {
        try {
            OrderTypeEnum orderTypeEnum = OrderTypeEnum.codeAndDesc.get(baseOrder.getType());
            Integer smstype;
            List<String> smsParams = new ArrayList<String>();
            switch (orderTypeEnum) {
                case RENT_VEHICLE:
                    CompanyDetail startCompanyDetail = vehicleFeign.getCompanyDetail(orvd.getStartCompanyId()).getData();
                    CompanyDetail endCompanyDetail = vehicleFeign.getCompanyDetail(orvd.getEndCompanyId()).getData();
                    if(null != orvd.getEndCompanyId() && !SYS_FALSE.equals(orvd.getEndCompanyId())) {

                        //新的账单 记录
                        OrderAccount orderAccount = orderAccountBiz.selectOne(new OrderAccount(){{
                            setOrderId(baseOrder.getId());
                            setAccountType(AccountTypeEnum.IN_ORDER_PAY.getCode());
                        }});

                        if(BigDecimal.ZERO.equals(orderAccount.getDeductAmount())) {
                            //使用免费天数
                            if(null != orvd.getFreeDays() && orvd.getFreeDays() > 0) {
                                smstype = SmsTemplateDTO.CANCEL_B;
                            }else {
                                smstype = SmsTemplateDTO.CANCEL_A;
                            }

                            //发送用户取消消息
                            sms2AppUser(startCompanyDetail, endCompanyDetail, orvd, otd, omd, baseOrder, appUserDTO, smstype, smsParams);
                        }else {
                            //使用免费天数
                            if(null != orvd.getFreeDays() && orvd.getFreeDays() > 0) {
                                smstype = SmsTemplateDTO.CANCEL_D;
                            }else {
                                smstype = SmsTemplateDTO.CANCEL_C;
                            }

                            //发送用户退款消息
                            smsParams.clear();
                            sms2RefundAppUser(BigDecimal.ZERO, orderAccount.getDeductAmount(), orderAccount.getAccountAmount(), BigDecimal.ZERO, baseOrder, appUserDTO, smstype, smsParams);
                        }



                        //后台发送消息(出车人)
                        smsParams.clear();
                        sms2BgUser(startCompanyDetail.getVehiceServicePhone(), startCompanyDetail, endCompanyDetail, orvd, otd, baseOrder, appUserDTO, SmsTemplateDTO.CANCEL_E, smsParams);
                    }else {
                        log.error("通知后台客户短信异常，结束公司id 不存在或者为0 订单号：{}", baseOrder.getId());
                    }
                    break;
                case TOUR:
                    CompanyDetail startCompanyDetailTour = vehicleFeign.getCompanyDetail(otd.getStartCompanyId()).getData();

                    //后台发送消息(客服)
                    Cofig cofig = configFeign.getAllByType(ConfigFeign.TYPE_CUS_SER+ "").getData().get(0);
                    smsParams.clear();
                    sms2BgUser(cofig.getValue(), startCompanyDetailTour, null, orvd, otd, baseOrder, appUserDTO, SmsTemplateDTO.PAY_C, smsParams);
                    break;
                case MEMBER:
                    break;
                default:
                    break;
            }
        }catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    /**
     * 取消订单处理提醒短信的发送
     * @param orvd
     * @param baseOrder
     * @param appUserDTO
     */
    public void handelMsgStart(OrderRentVehicleDetail orvd, OrderTourDetail otd, OrderMemberDetail omd, BaseOrder baseOrder, AppUserDTO appUserDTO) {
        try {
            OrderTypeEnum orderTypeEnum = OrderTypeEnum.codeAndDesc.get(baseOrder.getType());
            List<String> smsParams = new ArrayList<String>();
            switch (orderTypeEnum) {
                case RENT_VEHICLE:
                    CompanyDetail startCompanyDetail = vehicleFeign.getCompanyDetail(orvd.getStartCompanyId()).getData();
                    CompanyDetail endCompanyDetail = vehicleFeign.getCompanyDetail(orvd.getEndCompanyId()).getData();
                    if(null != orvd.getEndCompanyId() && !SYS_FALSE.equals(orvd.getEndCompanyId())) {
                        sms2AppUser(startCompanyDetail, endCompanyDetail, orvd, otd, omd, baseOrder, appUserDTO, SmsTemplateDTO.PAY_I, smsParams);
                    }else {
                        log.error("通知后台客户短信异常，结束公司id 不存在或者为0 订单号：{}", baseOrder.getId());
                    }
                    break;
                case TOUR:
                    CompanyDetail startCompanyDetailTour = vehicleFeign.getCompanyDetail(otd.getStartCompanyId()).getData();
                    sms2AppUser(startCompanyDetailTour, null, orvd, otd, omd, baseOrder, appUserDTO, SmsTemplateDTO.PAY_J, smsParams);
                    break;
                case MEMBER:
                    break;
                default:
                    break;
            }
        }catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }

    /**
     * 订单完成后处理押金提醒短信的发送
     * @param baseOrder
     * @param appUserDTO
     */
    public void handelMsgDeposit(OrderRentVehicleDetail orvd, BaseOrder baseOrder, AppUserDTO appUserDTO) {
        try {
            Integer smstype;
            List<String> smsParams = new ArrayList<String>();
            BigDecimal originalAmount;
            BigDecimal violateAmount;
            BigDecimal refundAmount;
            BigDecimal residueAmount;
            //查询订单退款记录
            OrderRefund orderRefund;
            if(RefundStatusEnum.RESIDUE_ILLEGAL.equals(baseOrder.getRefundStatus())) {
                smstype = SmsTemplateDTO.REFUND_A;
                orderRefund = orderRefundBiz.selectOne(new OrderRefund(){{
                    setOrderId(baseOrder.getId());
                    setRefundType(RefundTypeEnum.PART_DEPOSIT.getCode());
                }});
                originalAmount = orvd.getDeposit();
                violateAmount = orderRefund.getDeductAmount();
                refundAmount = orderRefund.getRefundAmount();
                residueAmount = orvd.getReturnPayResidue();
            }else if(RefundStatusEnum.REFUND_DEPOSIT.equals(baseOrder.getRefundStatus())){
                smstype = SmsTemplateDTO.REFUND_B;
                orderRefund = orderRefundBiz.selectOne(new OrderRefund(){{
                    setOrderId(baseOrder.getId());
                    setRefundType(RefundTypeEnum.RESIDUE_DEPOSIT.getCode());
                }});
                originalAmount = orderRefund.getOriginalRefundAmount();
                violateAmount = orderRefund.getDeductAmount();
                refundAmount = orderRefund.getRefundAmount();
                residueAmount = BigDecimal.ZERO;
            }else {
                throw new BaseException(ResultCode.PARAM_ILLEGAL_CODE, new HashSet<String>() {{
                    add("当前退款状态不对，订单号："+ baseOrder.getNo());
                }});
            }

            //发送用户押金信息退还消息
            sms2RefundAppUser(originalAmount, violateAmount, refundAmount, residueAmount, baseOrder, appUserDTO, smstype, smsParams);
        }catch (Exception e) {
            log.error(e.getMessage(), e);
        }
    }


    private void sms2AppUser(CompanyDetail startCompanyDetail, CompanyDetail endCompanyDetail, OrderRentVehicleDetail orvd, OrderTourDetail otd, OrderMemberDetail omd, BaseOrder baseOrder, AppUserDTO appUserDTO, Integer smstype, List<String> smsParams) {
        handelSmsParamApp(startCompanyDetail, endCompanyDetail, orvd, otd, omd, baseOrder, smsParams, appUserDTO, smstype);
        SmsTemplateDTO smsTemplateDTO = new SmsTemplateDTO(){{
            setPhoneNumbers(appUserDTO.getUsername());
            setType(smstype);
            setParams(smsParams.toArray(new String[smsParams.size()]));
        }};
        thirdFeign.sendTemplate(smsTemplateDTO);
    }
    private void sms2RefundAppUser(BigDecimal originalAmount, BigDecimal violateAmount, BigDecimal refundAmount, BigDecimal residueAmount, BaseOrder baseOrder, AppUserDTO appUserDTO, Integer smstype, List<String> smsParams) {
        handelDepositSmsParamApp(originalAmount, violateAmount, refundAmount, residueAmount, baseOrder, smsParams, appUserDTO, smstype);
        SmsTemplateDTO smsTemplateDTO = new SmsTemplateDTO(){{
            setPhoneNumbers(appUserDTO.getUsername());
            setType(smstype);
            setParams(smsParams.toArray(new String[smsParams.size()]));
        }};
        thirdFeign.sendTemplate(smsTemplateDTO);
    }


    private void sms2BgUser(String phone,BranchCompany sCompany, BranchCompany eCompany, OrderRentVehicleDetail orvd, OrderTourDetail otd, BaseOrder baseOrder, AppUserDTO appUserDTO, Integer smstype, List<String> smsParams) {
        handelSmsParamBg(sCompany, eCompany, orvd, otd, baseOrder, smsParams, appUserDTO, smstype);
        SmsTemplateDTO smsTemplateDTO = new SmsTemplateDTO(){{
            setPhoneNumbers(phone);
            setType(smstype);
            setParams(smsParams.toArray(new String[smsParams.size()]));
        }};
        thirdFeign.sendTemplate(smsTemplateDTO);
    }

    private void handelSmsParam(OrderRentVehicleDetail orvd, BaseOrder baseOrder, List<String> smsParams, AppUserDTO appUserDTO, int handelType) {
        if(RENT_DELIVERY == handelType) {
            smsParams.add(appUserDTO.getRealname());
            smsParams.add(DateUtil.formatDateTime(DateUtil.date(orvd.getEndTime())));
            smsParams.add(orvd.getEndAddr());
            smsParams.add(baseOrder.getName());
            smsParams.add(appUserDTO.getUsername());
        }else {
            smsParams.add(appUserDTO.getRealname());
            smsParams.add(baseOrder.getName());
            smsParams.add(orvd.getStartAddr());
            smsParams.add(orvd.getEndAddr());
            smsParams.add(DateUtil.formatDateTime(DateUtil.date(orvd.getStartTime())));
            smsParams.add(DateUtil.formatDateTime(DateUtil.date(orvd.getEndTime())));
            smsParams.add(orvd.getDayNum().toString());
            smsParams.add(appUserDTO.getUsername());
        }
    }

    private void handelSmsParamApp(CompanyDetail startCompanyDetail, CompanyDetail endCompanyDetail, OrderRentVehicleDetail orvd, OrderTourDetail otd, OrderMemberDetail omd, BaseOrder baseOrder, List<String> smsParams, AppUserDTO appUserDTO, int paramHandelType) {
        switch (paramHandelType) {
            case SmsTemplateDTO.PAY_A :
                if(SYS_TRUE.equals(appUserDTO.getIsMember()) && !NONE.getCode().equals(appUserDTO.getMemberLevel()) ) {
                    smsParams.add(USER_M+ appUserDTO.getRealname());
                }else {
                    smsParams.add(USER_N+ appUserDTO.getRealname());
                }
                smsParams.add(baseOrder.getRealAmount().toString());
                smsParams.add(DateUtil.formatDateTime(DateUtil.date(orvd.getStartTime())));
                smsParams.add(startCompanyDetail.detailAddr());
                break;
            case SmsTemplateDTO.PAY_B :
                smsParams.add(appUserDTO.getRealname());
                smsParams.add(orvd.getFreeDays().toString());
                smsParams.add(appUserDTO.getRentFreeDays().toString());
                smsParams.add(baseOrder.getRealAmount().toString());
                smsParams.add(DateUtil.formatDateTime(DateUtil.date(orvd.getStartTime())));
                smsParams.add(startCompanyDetail.detailAddr());
                break;
            case SmsTemplateDTO.PAY_F :
                smsParams.add(baseOrder.getName());
                smsParams.add(baseOrder.getRealAmount().toString());
                smsParams.add(DateUtil.formatDateTime(DateUtil.date(otd.getStartTime())));
                smsParams.add(startCompanyDetail.detailAddr());
                break;
            case SmsTemplateDTO.PAY_G :
                smsParams.add(baseOrder.getName());
                smsParams.add(baseOrder.getRealAmount().toString());
                smsParams.add(omd.getRentFreeNum().toString());
                smsParams.add(appUserDTO.getRentFreeDays().toString());
                break;
            case SmsTemplateDTO.CANCEL_A :
                if(SYS_TRUE.equals(appUserDTO.getIsMember()) && !NONE.getCode().equals(appUserDTO.getMemberLevel()) ) {
                    smsParams.add(USER_M+ appUserDTO.getRealname());
                }else {
                    smsParams.add(USER_N+ appUserDTO.getRealname());
                }
                break;
            case SmsTemplateDTO.CANCEL_B :
                if(SYS_TRUE.equals(appUserDTO.getIsMember()) && !NONE.getCode().equals(appUserDTO.getMemberLevel()) ) {
                    smsParams.add(USER_M+ appUserDTO.getRealname());
                }else {
                    smsParams.add(USER_N+ appUserDTO.getRealname());
                }
                break;
            case SmsTemplateDTO.PAY_I :
                if(SYS_TRUE.equals(appUserDTO.getIsMember()) && !NONE.getCode().equals(appUserDTO.getMemberLevel()) ) {
                    smsParams.add(USER_M+ appUserDTO.getRealname());
                }else {
                    smsParams.add(USER_N+ appUserDTO.getRealname());
                }
                smsParams.add(startCompanyDetail.getAddrDetail());
                break;
            case SmsTemplateDTO.PAY_J :
                if(SYS_TRUE.equals(appUserDTO.getIsMember()) && !NONE.getCode().equals(appUserDTO.getMemberLevel()) ) {
                    smsParams.add(USER_M+ appUserDTO.getRealname());
                }else {
                    smsParams.add(USER_N+ appUserDTO.getRealname());
                }
                smsParams.add(baseOrder.getName());
                smsParams.add(HOUR_MINUTE_FORMATTE_HUTOOL.format(DateUtil.date(otd.getStartTime())));
                smsParams.add(startCompanyDetail.getAddrDetail());
                break;
            default:
                break;
        }
    }

    private void handelDepositSmsParamApp(BigDecimal originalAmount, BigDecimal violateAmount, BigDecimal refundAmount, BigDecimal residueAmount,BaseOrder baseOrder, List<String> smsParams, AppUserDTO appUserDTO, int paramHandelType) {
        switch (paramHandelType) {
            case SmsTemplateDTO.CANCEL_C :
                if(SYS_TRUE.equals(appUserDTO.getIsMember()) && !NONE.getCode().equals(appUserDTO.getMemberLevel()) ) {
                    smsParams.add(USER_M+ appUserDTO.getRealname());
                }else {
                    smsParams.add(USER_N+ appUserDTO.getRealname());
                }
                smsParams.add(violateAmount.toString());
                smsParams.add(refundAmount.toString());
                break;
            case SmsTemplateDTO.CANCEL_D :
                smsParams.add(violateAmount.toString());
                smsParams.add(refundAmount.toString());
                break;
            case SmsTemplateDTO.REFUND_A:
                Map<String, Dictionary> dictionaryMap = thirdFeign.dictionaryGetAll4Map().getData();
                Integer rentDepositAutoRefundTime = new Integer(dictionaryMap.get(APP_ORDER+ "_"+ DictionaryKey.RENT_DEPOSIT_AUTO_REFUND_TIME).getDetail());
                if(SYS_TRUE.equals(appUserDTO.getIsMember()) && !NONE.getCode().equals(appUserDTO.getMemberLevel()) ) {
                    smsParams.add(USER_M+ appUserDTO.getRealname());
                }else {
                    smsParams.add(USER_N+ appUserDTO.getRealname());
                }
                smsParams.add(baseOrder.getNo());
                smsParams.add(originalAmount.toString());
                smsParams.add(violateAmount.toString());
                smsParams.add(refundAmount.toString());
                smsParams.add(residueAmount.toString());
                smsParams.add(DateUtil.formatDateTime(DateUtil.date(baseOrder.getRefundTime() + Long.valueOf(rentDepositAutoRefundTime * 60 * 60 * 1000))));
                break;
            case SmsTemplateDTO.REFUND_B:
                if(SYS_TRUE.equals(appUserDTO.getIsMember()) && !NONE.getCode().equals(appUserDTO.getMemberLevel()) ) {
                    smsParams.add(USER_M+ appUserDTO.getRealname());
                }else {
                    smsParams.add(USER_N+ appUserDTO.getRealname());
                }
                smsParams.add(baseOrder.getNo());
                smsParams.add(originalAmount.toString());
                smsParams.add(violateAmount.toString());
                smsParams.add(refundAmount.toString());
                break;
            default:
                break;
        }
    }

    private void handelSmsParamBg(BranchCompany sCompany, BranchCompany eCompany, OrderRentVehicleDetail orvd, OrderTourDetail otd, BaseOrder baseOrder, List<String> smsParams, AppUserDTO appUserDTO, int paramHandelType) {
        if(null == eCompany) {
            eCompany = new BranchCompany();
            eCompany.setName("");
            eCompany.setVehiceServicePhone("");
        }
        switch (paramHandelType) {
            case SmsTemplateDTO.PAY_C :
                smsParams.add(appUserDTO.getRealname());
                smsParams.add(appUserDTO.getUsername());
                smsParams.add(baseOrder.getName());
                smsParams.add(sCompany.getName());
                smsParams.add(sCompany.getVehiceServicePhone());
                smsParams.add(eCompany.getName());
                smsParams.add(eCompany.getVehiceServicePhone());
                smsParams.add(DateUtil.formatDateTime(DateUtil.date(orvd.getStartTime())));
                smsParams.add(DateUtil.formatDateTime(DateUtil.date(orvd.getEndTime())));
                smsParams.add(orvd.getDayNum().toString());
                break;
            case SmsTemplateDTO.PAY_D :
                smsParams.add(appUserDTO.getRealname());
                smsParams.add(appUserDTO.getUsername());
                smsParams.add(baseOrder.getName());
                smsParams.add(sCompany.getName());
                smsParams.add(eCompany.getName());
                smsParams.add(DateUtil.formatDateTime(DateUtil.date(orvd.getStartTime())));
                smsParams.add(DateUtil.formatDateTime(DateUtil.date(orvd.getEndTime())));
                smsParams.add(orvd.getDayNum().toString());
                break;
            case SmsTemplateDTO.PAY_E :
                smsParams.add(appUserDTO.getRealname());
                smsParams.add(appUserDTO.getUsername());
                smsParams.add(DateUtil.formatDateTime(DateUtil.date(orvd.getStartTime())));
                smsParams.add(sCompany.getName());
                smsParams.add(baseOrder.getName());
                break;
            case SmsTemplateDTO.CANCEL_E :
                smsParams.add(appUserDTO.getRealname());
                smsParams.add(appUserDTO.getUsername());
                smsParams.add(baseOrder.getName());
                smsParams.add(sCompany.getName());
                smsParams.add(eCompany.getName());
                smsParams.add(DateUtil.formatDateTime(DateUtil.date(orvd.getStartTime())));
                smsParams.add(DateUtil.formatDateTime(DateUtil.date(orvd.getEndTime())));
                smsParams.add(orvd.getDayNum().toString());
                break;
            case SmsTemplateDTO.PAY_H :
                smsParams.add(appUserDTO.getRealname());
                smsParams.add(appUserDTO.getUsername());
                smsParams.add(baseOrder.getName());
                smsParams.add(sCompany.getName());
                smsParams.add(sCompany.getTourServicePhone());
                smsParams.add(DateUtil.formatDateTime(DateUtil.date(otd.getStartTime())));
                break;
            case SmsTemplateDTO.CANCEL_F :
                smsParams.add(appUserDTO.getRealname());
                smsParams.add(appUserDTO.getUsername());
                smsParams.add(baseOrder.getName());
                smsParams.add(sCompany.getName());
                smsParams.add(sCompany.getTourServicePhone());
                smsParams.add(DateUtil.formatDateTime(DateUtil.date(otd.getStartTime())));
                break;
            default:
                break;
        }
    }
}