package com.xinxincaravan.caravan.vehicle.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.xinxincaravan.caravan.vehicle.biz.BranchCompanyStockService;
import com.xinxincaravan.caravan.vehicle.common.RestResponse;
import com.xinxincaravan.caravan.vehicle.constant.ResCode.ResCode;
import com.xinxincaravan.caravan.vehicle.entity.BranchCompanyStockApplyInfo;
import com.xinxincaravan.caravan.vehicle.vo.BranchCompanyStockApplyVo;
import com.xinxincaravan.caravan.vehicle.vo.BranchCompanyStockInfoVo;
import com.xinxincaravan.caravan.vehicle.vo.BranchCompanyStockSearchVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;

@RestController
@IgnoreClientToken
@IgnoreUserToken
@RequestMapping("branchCompany/stock")
public class BranchCompanyStockController {

    private static Integer MAX_DRIVING_LICENSE_SIZE  = 10*1024*1024;//10M

    @Autowired
    BranchCompanyStockService branchCompanyStockService;

    /**
     * 分页获取
     * @param page
     * @param limit
     * @return
     */
    @GetMapping("page")
    public RestResponse page(Integer page, Integer limit) {
        if (page == null || limit == null) {
            page = 1;
            limit = 10;
        }
        return RestResponse.suc(branchCompanyStockService.selectAll(page, limit));
    }

    /**
     * 搜索
     * @param searchVo
     * @return
     */
    @GetMapping("search")
    public RestResponse search(BranchCompanyStockSearchVo searchVo) {
        if (searchVo.getPage() == null || searchVo.getLimit() == null) {
            searchVo.setPage(1);
            searchVo.setLimit(10);
        }
        return RestResponse.suc(branchCompanyStockService.search(searchVo));
    }

    @GetMapping("{id}")
    public RestResponse get(@PathVariable("id") Integer id) {
        if (id == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        return RestResponse.suc(branchCompanyStockService.selectById(id));
    }

    /**
     * 添加
     * @return
     */
    @PutMapping
    public RestResponse add(@RequestBody BranchCompanyStockInfoVo stockInfoVo) {
        if (stockInfoVo.getCompanyName() == null || stockInfoVo.getTotal() == null || stockInfoVo.getPrice() == null
        || stockInfoVo.getAddrProvince() == null || stockInfoVo.getAddrCity() == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        branchCompanyStockService.insert(stockInfoVo);
        return RestResponse.suc();
    }

    /**
     * 修改
     * @param stockInfoVo
     * @return
     */
    @PostMapping
    public RestResponse update(@RequestBody BranchCompanyStockInfoVo stockInfoVo) {
        if (stockInfoVo.getId() == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        branchCompanyStockService.update(stockInfoVo);
        return RestResponse.suc();
    }

    @DeleteMapping("{id}")
    public RestResponse delete(@PathVariable("id") Integer id) {
        branchCompanyStockService.delete(id);
        return RestResponse.suc();
    }

    @RequestMapping(value ="/upload/companyPic",method = RequestMethod.POST)
    public RestResponse uploadCompanyPic(@RequestParam("file") MultipartFile file)
            throws Exception{
        String contentType = file.getContentType();   //图片文件类型
        if(!contentType.equals("image/jpeg") && !contentType.equals("image/gif")){
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        }
        if(file.getSize() > MAX_DRIVING_LICENSE_SIZE){
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        }
        return branchCompanyStockService.uploadCompanyPic(file);
    }

    @IgnoreUserToken
    @RequestMapping(value="/download/companyPic",method=RequestMethod.GET)
    public ResponseEntity<byte[]> downloadDrivingLicense(@RequestParam("realFileRelPath") String realFileRelPath) throws Exception {
        return branchCompanyStockService.downloadCompanyPic(realFileRelPath);
    }

    /**
     * 申请购买
     * @param applyVo
     * @return
     */
    @PostMapping("apply")
    public RestResponse apply(@RequestBody BranchCompanyStockApplyVo applyVo) {
        if (applyVo.getCompanyId() == null || applyVo.getName() == null || applyVo.getTel() == null || applyVo.getCount() == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        branchCompanyStockService.apply(applyVo);
        return RestResponse.suc();
    }

    @GetMapping("apply/page")
    public RestResponse applyPage(Integer page, Integer limit) {
        if (page == null || limit == null) {
            page = 1;
            limit = 10;
        }
        return RestResponse.suc(branchCompanyStockService.selectApplyAll(page, limit));
    }

    @GetMapping("apply/{id}")
    public RestResponse getApplyById(@PathVariable("id") Integer id) {
        if (id == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        return RestResponse.suc(branchCompanyStockService.getApplyById(id));
    }

    @PutMapping("apply")
    public RestResponse updateApply(BranchCompanyStockApplyInfo applyInfo) {
        if (applyInfo.getId() == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        branchCompanyStockService.updateApply(applyInfo);
        return RestResponse.suc();
    }

    @DeleteMapping("apply/{id}")
    public RestResponse deleteApply(@PathVariable("id") Integer id) {
        if (id == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        branchCompanyStockService.deleteApply(id);
        return RestResponse.suc();
    }

    /**
     * 取消申请，放弃购买
     * @return
     */
    @PostMapping("apply/cancel")
    public RestResponse cancel(Integer applyId) {
        if (applyId == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        branchCompanyStockService.cancelApply(applyId);
        return RestResponse.suc();
    }

    /**
     * 确认购买，减库存
     */
    @PostMapping("apply/buy")
    public RestResponse buy(Integer applyId) {
        if (applyId == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        branchCompanyStockService.buy(applyId);
        return RestResponse.suc();
    }

    @GetMapping("allPrice")
    public RestResponse getAllPrice() {
        return RestResponse.suc(branchCompanyStockService.getAllPrice());
    }


    /**
     * 导入
     * @param multipartfile
     * @param request
     * @return
     */
    @PostMapping("importExcel")
    public RestResponse importExcel(@RequestParam(value = "file") MultipartFile multipartfile,
                                    HttpServletRequest request) {
        return branchCompanyStockService.importExcel(multipartfile,request);
    }

}
