package com.xinxincaravan.caravan.vehicle.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.common.context.BaseContextHandler;
import com.xinxincaravan.caravan.vehicle.biz.BranchCompanyBiz;
import com.xinxincaravan.caravan.vehicle.biz.VehicleBiz;
import com.xinxincaravan.caravan.vehicle.common.BaseController;
import com.xinxincaravan.caravan.vehicle.common.RestResponse;
import com.xinxincaravan.caravan.vehicle.constant.ResCode.ResCode;
import com.xinxincaravan.caravan.vehicle.entity.BranchCompany;
import com.xinxincaravan.caravan.vehicle.entity.Vehicle;
import com.xinxincaravan.caravan.vehicle.feign.UserFeign;
import com.xinxincaravan.caravan.vehicle.feign.dto.UserDTO;
import com.xinxincaravan.caravan.vehicle.vo.BranchCompanyVo;
import com.xinxincaravan.caravan.vehicle.vo.PageDataVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

@RestController
@RequestMapping("/branchCompany")
@Slf4j
@IgnoreClientToken
public class BranchCompanyController extends BaseController<BranchCompanyBiz> {

    private static Integer MAX_DRIVING_LICENSE_SIZE  = 10*1024*1024;//10M

    @Autowired
    UserFeign userFeign;

    @Autowired
    VehicleBiz vehicleBiz;

    @Autowired
    private UserAuthConfig userAuthConfig;

    @IgnoreUserToken
    @RequestMapping(value ="/page",method = RequestMethod.GET)
    public RestResponse<PageDataVo<BranchCompany>> page(@RequestParam Integer page, @RequestParam Integer limit,
                                                          @RequestParam(required = false) Integer addrProvince, @RequestParam(required = false) Integer addrCity,
                                                          @RequestParam(required = false) Integer addrTown) {
        UserDTO userDTO = userFeign.userinfoByToken(userAuthConfig.getToken(request)).getData();
//        log.info(JSONObject.toJSONString(userDTO));
//        log.info(JSONObject.toJSONString(vehicleBiz.dataCompany(userDTO.getDataZone(), userDTO.getDataCompany())));
        return RestResponse.data(baseBiz.getAll(page,limit,addrProvince,  addrCity, addrTown, userDTO));
    }

    @RequestMapping(value ="",method = RequestMethod.GET)
    public RestResponse<List<BranchCompany>> getAll() {
        return RestResponse.data(baseBiz.getAll());
    }

    @RequestMapping(value ="/{id}",method = RequestMethod.GET)
    public RestResponse<BranchCompany> get(@PathVariable Integer id) {
        return RestResponse.data(baseBiz.getById(id));
    }

    @RequestMapping(value ="",method = RequestMethod.POST)
    public RestResponse<Integer> add(@RequestBody BranchCompanyVo branchCompanyVo) {
        return RestResponse.data(baseBiz.add(branchCompanyVo));
    }

    @RequestMapping(value ="/upload/companyPic",method = RequestMethod.POST)
    public RestResponse uploadCompanyPic(@RequestParam("file") MultipartFile file)
            throws Exception{
        String contentType = file.getContentType();   //图片文件类型
//        String fileName = file.getOriginalFilename();  //图片名字
        if(!contentType.equals("image/jpeg") && !contentType.equals("image/gif")){
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        }
        if(file.getSize() > MAX_DRIVING_LICENSE_SIZE){
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        }
        return baseBiz.uploadCompanyPic(file);
    }

    @RequestMapping(value ="",method = RequestMethod.PUT)
    public RestResponse update(@RequestBody BranchCompany branchCompany) {
        baseBiz.update(branchCompany);
        return RestResponse.sucResponse();
    }

    @RequestMapping(value ="/{id}",method = RequestMethod.DELETE)
    public RestResponse del(@PathVariable Integer id) {
        baseBiz.del(id);
        return RestResponse.sucResponse();
    }

}
