package com.xinxincaravan.caravan.vehicle.entity;

import lombok.Data;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import java.math.BigDecimal;

@Data
@Table(name = "branch_company_stock_info")
public class BranchCompanyStockInfo {
    /**
     * 分公司ID
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "JDBC")
    private Integer id;

    /**
     * 剩余股份
     */
    private Integer balance;

    /**
     * 股份总数
     */
    private Integer total;

    /**
     * 股份单价
     */
    private BigDecimal price;

    private String companyName;
    private Integer addrProvince;
    private Integer addrCity;
    private Integer state;

    private String companyPic;

}