package com.xxfc.platform.order.service;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.order.biz.BaseOrderBiz;
import com.xxfc.platform.order.vo.OrderVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

public abstract class AbstractOrderHandle<Biz extends BaseBiz, VO extends OrderVO> implements OrderHandle {
    @Autowired
    protected Biz DetailOrderBiz;

    @Autowired
    protected BaseOrderBiz baseOrderBiz;

    public void createOrder(VO vo) {
        baseOrderBiz.insertSelective(vo.getBaseOrder());
    }

    public void modifyOrder(VO vo) {
        baseOrderBiz.updateSelectiveById(vo.getBaseOrder());
    }

}
