package com.xxfc.platform.order.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.CommonBaseController;
import com.xxfc.platform.order.entity.OrderRentCar;
import com.xxfc.platform.order.service.OrderRentCarService;
import com.xxfc.platform.order.vo.OrderVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping("orderRentCar")
public class OrderRentCarController extends CommonBaseController {

        @Autowired
        OrderRentCarService orderRentCarService;

        @RequestMapping(value = "add",method = RequestMethod.POST)
        @ResponseBody
        public ObjectRestResponse<OrderRentCar> add(@RequestBody OrderVO<OrderRentCar> vo){
            orderRentCarService.createOrder(vo);
            return new ObjectRestResponse<OrderRentCar>();
        }
}