package com.xxfc.platform.order.entity;

import com.github.wxiaoqi.security.common.entity.BaseEntity;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.*;


/**
 *
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-15 21:30:33
 */
@Table(name = "base_order")
@Data
public class BaseOrder extends BaseEntity {
	private static final long serialVersionUID = 1L;

	//主键
	@Id
	private Integer id;

	//订单号
	@Column(name = "no")
	private String no;

	//订单类型
	@Column(name = "type")
	private Integer type;

	//订单详情id
	@Column(name = "detail_id")
	private Integer detailId;

	//订单状态
	@Column(name = "status")
	private Integer status;

	//商品价格
	@Column(name = "product_amount")
	private BigDecimal productAmount;

	//实际价格
	@Column(name = "order_amount")
	private BigDecimal orderAmount;

	//详情json信息
	@Column(name = "detail_json")
	private String detailJson;

	//第三方类型（支付渠道）
	@Column(name = "third_type")
	private Integer thirdType;

	//流水号
	@Column(name = "out_trade_no")
	private String outTradeNo;

	//创建时间
	@Column(name = "crt_time")
	private Date crtTime;

	//创建者id
	@Column(name = "crt_user")
	private String crtUser;

	//创建者名称
	@Column(name = "crt_name")
	private String crtName;

	//创建者ip
	@Column(name = "crt_host")
	private String crtHost;

	//更新时间
	@Column(name = "upd_time")
	private Date updTime;

	//更新者id
	@Column(name = "upd_user")
	private String updUser;

	//更新者名称
	@Column(name = "upd_name")
	private String updName;

	//更新者ip
	@Column(name = "upd_host")
	private String updHost;
}
