package com.github.wxiaoqi.security.admin.rpc.service;

import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.admin.biz.AppUserBiz;
import com.github.wxiaoqi.security.admin.biz.AppUserDetailBiz;
import com.github.wxiaoqi.security.admin.biz.AppUserLoginBiz;
import com.github.wxiaoqi.security.admin.biz.ElementBiz;
import com.github.wxiaoqi.security.admin.entity.*;
import com.github.wxiaoqi.security.api.vo.authority.PermissionInfo;
import com.github.wxiaoqi.security.api.vo.user.AppUserInfo;
import com.github.wxiaoqi.security.common.util.VerificationUtils;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.util.process.SystemConfig;
import com.github.wxiaoqi.security.common.util.result.JsonResultUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @author keliii
 */
@Service
@Slf4j
public class AppPermissionService {

    @Autowired
    AppUserBiz appUserBiz;

    @Autowired
    ElementBiz elementBiz;

    private BCryptPasswordEncoder encoder = new BCryptPasswordEncoder(12);
    @Autowired
    private RedisTemplate userRedisTemplate;
    @Autowired
    private AppUserDetailBiz appUserDetailBiz;
    @Autowired
    private AppUserLoginBiz appUserLoginBiz;


    public AppUserInfo validate(String username, String password) {
        AppUserInfo info = new AppUserInfo();
        AppUser user = appUserBiz.getUserByUsername(username);
        if (encoder.matches(password, user.getPassword())) {
            BeanUtils.copyProperties(user, info);
            info.setId(user.getId().toString());
        }
        return info;
    }

    public List<PermissionInfo> getPermissionByUsername(String username) {
        AppUser user = appUserBiz.getUserByUsername(username);
        List<PermissionInfo> result = new ArrayList<>();
//        List<Element> elements = elementBiz.getAuthorityElementByUserId(user.getId().toString());
        List<Element> elements = elementBiz.getAuthorityElementByAppUserId(user.getId().toString());
        element2permission(result, elements);
        return result;
    }

    private void element2permission(List<PermissionInfo> result, List<Element> elements) {
        PermissionInfo info;
        for (Element element : elements) {
            info = new PermissionInfo();
            info.setCode(element.getCode());
            info.setType(element.getType());
            info.setUri(element.getUri());
            info.setMethod(element.getMethod());
            info.setName(element.getName());
            info.setMenu(element.getMenuId());
            result.add(info);
        }
    }


    /**
     * 发送短信
     *
     * @param phone
     * @param type
     * @return phone手机号 type:类型(0用户注册,1微信绑定,2人脸注册,3忘记密码,4直接发送验证码) 改写发送验证码方法（暂时通过测试）
     */

    public JSONObject sendSMS(String phone, Integer type) {
        if (StringUtils.isBlank(phone) || type == null) {
            return JsonResultUtil.createFailedResult(ResultCode.NULL_CODE, "参数为空");
        }
        // 验证手机号码是否正确
        if (!VerificationUtils.getPvu().checkMobileNumber(phone)) {
            return JsonResultUtil.createFailedResult(ResultCode.FAILED_CODE, "手机号码有误");
        }
        // 组织返回结果集
        JSONObject result = new JSONObject();
        if (type == 0) {
            AppUserLogin rsUserLogin = appUserLoginBiz.checkeUserLogin(phone);
            if (rsUserLogin != null)
                return JsonResultUtil.createFailedResult(ResultCode.EXIST_CODE, "用户已存在");
        } else if (type == 1) {
            AppUserLogin rsUserLogin = appUserLoginBiz.checkeUserLogin(phone);

            // 判断手机号码是否已绑定
            boolean isBind = appUserLoginBiz.checkeWechatUser(rsUserLogin);
            if (!isBind) {
                return JsonResultUtil.createFailedResultMsg(ResultCode.WX_BIND_CODE);
            } else {
                result.put("registered", rsUserLogin != null);
            }
        }/* else if (type == 3) {
            if (checkeUserLogin(phone) == null)
                return JsonResultUtil.createFailedResult(ResultCode.FAILED_CODE, "手机号未注册，请确认手机号无误");
        }*/ else if (type == 4) {
            AppUserLogin rsUserLogin = appUserLoginBiz.checkeUserLogin(phone);
            if (rsUserLogin != null)
                return JsonResultUtil.createFailedResult(ResultCode.EXIST_CODE, "手机号已注册");
        }
        // String sms = PassportUtil.SendSMS(phone, SystemConfig.SENDSMS_TITLE);
        String mobilecode="123456";
        log.info("调用短信发送接口返回值为：{}", mobilecode);
        // 判断返回值是否为空，并且是否可以转换成JSONObject
        if (StringUtils.isBlank(mobilecode))
            return JsonResultUtil.createDefaultFail();
        try {
           /* JSONObject smsJSON = JSONObject.parseObject(sms);
            if (smsJSON.getIntValue("error") != 0)
                return JsonResultUtil.createDefaultFail();
            JSONObject data = smsJSON.getJSONObject("data");
            if (data == null)
                return JsonResultUtil.createDefaultFail();
            String mobilecode = data.getString("mobilecode");
            if (mobilecode != null) {
                result.put("mobilecode", mobilecode);
                redisDao.set(phone + mobilecode, String.class, mobilecode, 300);
            }*/
            result.put("mobilecode", mobilecode);
            // redisDao.set(phone + mobilecode, String.class, mobilecode, 300);
            userRedisTemplate.opsForValue().set(phone + mobilecode,mobilecode,300, TimeUnit.SECONDS);
        } catch (Exception e) {
            return JsonResultUtil.createFailedResult(ResultCode.EXCEPTION_CODE, "出现异常");
        }
        return JsonResultUtil.createSuccessResultWithObj(result);
    }

    /**
     * 注册用户
     *
     * @param username
     * @param password
     * @param headimgurl
     * @param mobilecode
     */
    @Transactional
    public JSONObject register(HttpServletRequest request, String username, String password, String headimgurl, String nickname, String mobilecode) {
        // 判断参数和验证码
        if (StringUtils.isBlank(username) || StringUtils.isBlank(password) || StringUtils.isBlank(mobilecode)) {
            return JsonResultUtil.createFailedResult(ResultCode.NULL_CODE, "参数为空");
        }
        String mobilecodeRedis=userRedisTemplate.opsForValue().get(username + mobilecode).toString();
        // 获取到缓存的验证码后要先清空缓存对应键的值
        userRedisTemplate.delete(username + mobilecode);
        log.error("注册接口，获取redis中的验证码：" + mobilecodeRedis);
        if (mobilecodeRedis == null) {
            return JsonResultUtil.createFailedResult(ResultCode.NOTEXIST_CODE, "验证码错误");
        }
        // 是否已存在
        AppUserLogin  user = appUserLoginBiz.checkeUserLogin(username);
        if (null != user) {
            return JsonResultUtil.createFailedResult(ResultCode.EXIST_CODE, "用户已存在");
        }
        // 新增用户登录信息
        try {
            Long now = System.currentTimeMillis() / 1000;
            AppUserLogin appUserLogin = new AppUserLogin();
            //String userid = result.getJSONObject("data").getString("userid");
            appUserLogin.setUsername(username);
            appUserLogin.setPassword(password);
            appUserLogin.setIsdel(0);
            appUserLogin.setStatus(0);
            appUserLogin.setCreatetime(now);
            appUserLogin.setUpdatetime(now);
            appUserLoginBiz.insertSelective(appUserLogin);
            Integer userid=appUserLogin.getId();
            log.error("注册：新增登陆用户信息： " + userid);
            // 新增用户详情
            AppUserDetail rsUserDetail = new AppUserDetail();
            rsUserDetail.setUserid(userid);
            rsUserDetail.setNickname(nickname);
            rsUserDetail.setHeadimgurl(headimgurl); // 默认路径，待写
            rsUserDetail.setCreatetime(now);
            rsUserDetail.setUpdatetime(now);
            rsUserDetail.setIsdel(0);
            appUserDetailBiz.insertSelective(rsUserDetail);
            log.error("注册：新增用户详情： " + userid);
            // 登录结果要做做统一处理
            JSONObject data = autoLogin(userid, username, headimgurl, nickname);
            /* // 到im注册，获取返回结果

             */
            if (data != null) {
                return JsonResultUtil.createSuccessResultWithObj(data);
            } else {
                return JsonResultUtil.createDefaultFail();
            }
        } catch (Exception e) {
            e.printStackTrace();
            return JsonResultUtil.createFailedResult(ResultCode.EXCEPTION_CODE, "出现异常");
        }
    }

    /**
     * 自动登录
     */
    public JSONObject autoLogin(Integer userid, String username, String headimgurl, String nickname) {
        JSONObject data = new JSONObject();
        AppUserLogin  userLoign = appUserLoginBiz.selectById(userid);
        if (userLoign!=null) {
            // 缓存操作
            String token="";
            String imtoken_="";
            userRedisTemplate.opsForValue().set("token_" + userid,token, SystemConfig.REDISTOKENTIME, TimeUnit.SECONDS);
            userRedisTemplate.opsForValue().set("imtoken_" + userid,imtoken_,SystemConfig.REDISTOKENTIME, TimeUnit.SECONDS);
            // 返回结果
            data.put("token", token);
            data.put("imtoken", imtoken_);
            data.put("nickname", nickname);
            data.put("headerurl",headimgurl);
        }
        return data;
    }
}
