package com.github.wxiaoqi.security.admin.rpc;

import com.ace.cache.annotation.Cache;
import com.alibaba.fastjson.JSONObject;
import com.github.wxiaoqi.security.admin.rpc.service.AppPermissionService;
import com.github.wxiaoqi.security.admin.rpc.service.PermissionService;
import com.github.wxiaoqi.security.api.vo.authority.PermissionInfo;
import com.github.wxiaoqi.security.api.vo.user.AppUserInfo;
import com.github.wxiaoqi.security.api.vo.user.UserInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author keliii
 */
@RestController
@RequestMapping("api/app")
public class AppUserRest {
    @Autowired
    private AppPermissionService appPermissionService;

//    @Cache(key="permission")
//    @RequestMapping(value = "/permissions", method = RequestMethod.GET)
//    public @ResponseBody
//    List<PermissionInfo> getAllPermission(){
//        return permissionService.getAllPermission();
//    }
//
    @Cache(key="app:permission:u{1}")
    @RequestMapping(value = "/user/un/{username}/permissions", method = RequestMethod.GET)
    public @ResponseBody List<PermissionInfo> getPermissionByUsername(@PathVariable("username") String username){
        return appPermissionService.getPermissionByUsername(username);
    }

    @RequestMapping(value = "/user/validate", method = RequestMethod.POST)
    public @ResponseBody
    AppUserInfo validate(@RequestBody Map<String,String> body){
        return appPermissionService.validate(body.get("username"),body.get("password"));
    }

    /**
     * 发送验证码
     * @param username
     * @param type 0-注册验证，1-找回密码验证，2&3-修改手机号
     * @return
     */
    @RequestMapping(value = "/user/sendsms", method = RequestMethod.POST)
    public @ResponseBody
    JSONObject sendsms(@RequestParam(value="username",defaultValue="")String  username, @RequestParam(value="type",defaultValue="0")Integer type){
        return appPermissionService.sendSMS(username,type);
    }


}
