package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.admin.biz.AppUserBiz;
import com.github.wxiaoqi.security.admin.entity.AppUser;
import com.github.wxiaoqi.security.admin.entity.Group;
import com.github.wxiaoqi.security.admin.entity.User;
import com.github.wxiaoqi.security.admin.vo.AppUserGroups;
import com.github.wxiaoqi.security.auth.client.config.UserAuthConfig;
import com.github.wxiaoqi.security.auth.client.jwt.UserAuthUtil;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.msg.TableResultResponse;
import com.github.wxiaoqi.security.common.rest.CommonBaseController;
import com.github.wxiaoqi.security.common.util.Query;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * @author keliii
 */
@RestController
@RequestMapping("app/user")
@Slf4j
public class AppUserController extends CommonBaseController {

    @Autowired
    AppUserBiz appUserBiz;

    @Autowired
    private UserAuthUtil userAuthUtil;

    @Autowired
    private UserAuthConfig userAuthConfig;

    @GetMapping("page")
    public TableResultResponse list(@RequestParam Map<String, Object> params) {
        Query query = new Query(params);
        try {
            return appUserBiz.selectPage(query,
                    appUserBiz.getUserByUsername(userAuthUtil.getInfoFromToken(userAuthConfig.getToken(request)).getUniqueName()));
        }catch (Exception e) {
            log.error(e.getMessage());
            return new TableResultResponse<User>();
        }
    }

    @RequestMapping(value = "/{id}",method = RequestMethod.GET)
    @ResponseBody
    public ObjectRestResponse<AppUser> get(@PathVariable int id){
        ObjectRestResponse<AppUser> entityObjectRestResponse = new ObjectRestResponse<>();
        AppUser o = appUserBiz.selectById(id);
        entityObjectRestResponse.data(o);
        return entityObjectRestResponse;
    }

    @RequestMapping(value = "/{id}",method = RequestMethod.PUT)
    @ResponseBody
    public ObjectRestResponse<AppUser> update(@RequestBody AppUser entity){
        appUserBiz.updateSelectiveById(entity);
        return new ObjectRestResponse<AppUser>();
    }
    @RequestMapping(value = "/{id}",method = RequestMethod.DELETE)
    @ResponseBody
    public ObjectRestResponse<AppUser> remove(@PathVariable int id){
        appUserBiz.deleteById(id);
        return new ObjectRestResponse<AppUser>();
    }

    @RequestMapping(value = "/all",method = RequestMethod.GET)
    @ResponseBody
    public List<AppUser> all(){
        return appUserBiz.selectListAll();
    }

    @GetMapping("groups/{id}")
    public List<Group> groups(@PathVariable Integer id) {
        return appUserBiz.selectGroupsByAppUserId(id);
    }

    @PostMapping("groups")
    public ObjectRestResponse insertAppUserGroups(@RequestBody AppUserGroups appUserGroups) {
        appUserBiz.insertAppUserGroup(appUserGroups.getAppUserId(), appUserGroups.getGroups());
        return new ObjectRestResponse();
    }

}
