package com.xxfc.platform.vehicle.entity;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Date;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/10/14 16:30
 */
@Data
@Builder(toBuilder = true)
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "vehicle_model_holiday_price")
public class VehicleModelHolidayPrice implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator = "JDBC")
    private Long id;
    /**
     * 节假日日期
     */
    @Column(name = "festival_day")
    private Date festivalDay;
    /**
     * 节假日
     */
    @Column(name = "festival_id")
    private Integer festivalId;
    /**
     * 倍数
     */
    private Double multiple;
    /**
     * 免费天数
     */
    @Column(name = "free_days")
    private Integer freeDays;
    /**
     * 创建时间
     */
    @Column(name = "crt_time")
    private Date crtTime;
    /**
     * 创建者
     */
    @Column(name = "crt_userId")
    private Integer crtUserId;
    /**
     * 更新时间
     */
    @Column(name = "upd_time")
    private Date updTime;
    /**
     * 更新者
     */
    @Column(name = "upd_userId")
    private Integer updUserId;

    @Column(name = "is_del")
    private Integer isDel;
}
