package com.xxfc.platform.order.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.joda.time.DateTime;
import org.springframework.format.annotation.DateTimeFormat;
import tk.mybatis.mapper.annotation.KeySql;
import tk.mybatis.mapper.code.IdentityDialect;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

/**
 * 每日租车订单统计
 *
 * @author Administrator
 */
@Data
@Table(name = "daily_vehicle_order_statistics")
public class DailyVehicleOrderStatistics extends DailyOrderStatistics {


    /**
     * 预交押金总额
     */
    @Column(name = "security_deposit")
    private BigDecimal securityDeposit=BigDecimal.ZERO;

    /**
     * 退还押金总额
     */
    @Column(name = "refund_security_deposit")
    private BigDecimal refundSecurityDeposit=BigDecimal.ZERO;

    /**
     * 损坏赔偿总额
     */
    @Column(name = "compensation")
    private BigDecimal compensation=BigDecimal.ZERO;

    /**
     * 违章总额
     */
    @Column(name = "forfeit")
    private BigDecimal forfeit=BigDecimal.ZERO;


    /**
     * 退还订单金额
     */
    @Column(name = "return_gmv")
    private BigDecimal returnGmv=BigDecimal.ZERO;




//    /**
//     * 取消订单扣款总额
//     */
//    @Column(name = "penal_sum")
//    private BigDecimal penalSum;


    /**
     *  违约总额
     */
    @Column(name = "default_money ")
    private BigDecimal defaultMoney=BigDecimal.ZERO;


    /**
     * 订单补偿
     */
    @Column(name = "order_compensation")
    private BigDecimal orderCompensation=BigDecimal.ZERO;


}
