package com.xxfc.platform.app.biz;

import com.github.wxiaoqi.security.admin.entity.AppUserLogin;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.app.entity.dto.BuyVehicleFormFindDTO;
import com.xxfc.platform.app.entity.vo.BuyVehicleFormPageVo;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import com.xxfc.platform.vehicle.pojo.vo.BranComanyLeaderVo;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.xxfc.platform.app.entity.BuyVehicleForm;
import com.xxfc.platform.app.mapper.BuyVehicleFormMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 购房车提交表单
 *
 * @author zjw
 * @email 18178966185@163.com
 * @date 2019-07-09 19:39:47
 */
@Service
public class BuyVehicleFormBiz extends BaseBiz<BuyVehicleFormMapper, BuyVehicleForm> {

    @Autowired
    private VehicleFeign vehicleFeign;

    @Autowired
    private UserFeign userFeign;

    public PageDataVO<BuyVehicleFormPageVo> findBuyVehicleFormWithPage(BuyVehicleFormFindDTO buyVehicleFormFindDTO) {
         PageDataVO<BuyVehicleFormPageVo> buyVehicleFormPage = new PageDataVO<>();
        List<Integer> cpyIds = new ArrayList<>();
        if(Objects.nonNull(buyVehicleFormFindDTO.getAreaId())){
            List<Integer> companyIds = vehicleFeign.findCompanyIdsByAreaId(buyVehicleFormFindDTO.getAreaId());
            if (Objects.isNull(buyVehicleFormFindDTO.getCompanyId())){
                cpyIds.addAll(companyIds);
            }else {
                boolean flag = companyIds.contains(buyVehicleFormFindDTO.getCompanyId());
                if (flag){
                    cpyIds.add(buyVehicleFormFindDTO.getCompanyId());
                }else {
                    return buyVehicleFormPage;
                }
            }
        }else {
            if (Objects.nonNull(buyVehicleFormFindDTO.getCompanyId())){
                cpyIds.add(buyVehicleFormFindDTO.getCompanyId());
            }
        }
        PageDataVO<BuyVehicleForm> pageDataVO = PageDataVO.pageInfo(buyVehicleFormFindDTO.getPage(),buyVehicleFormFindDTO.getLimit(),()->mapper.findBuyVehicleForms(buyVehicleFormFindDTO, cpyIds));

        List<BuyVehicleForm> data = pageDataVO.getData();
        if (CollectionUtils.isEmpty(data)){
            return buyVehicleFormPage;
        }

        List<Integer> companyIds = data.stream().map(BuyVehicleForm::getCompanyId).collect(Collectors.toList());
        Map<Integer, BranComanyLeaderVo> comanyLeaderVoMap = vehicleFeign.findCompanyLeaderMapByIds(companyIds);

        List<BuyVehicleFormPageVo> buyVehicleFormPageVoList = new ArrayList<>();
        BuyVehicleFormPageVo buyVehicleFormPageVo;
        for (BuyVehicleForm buyVehicleForm : data) {
             buyVehicleFormPageVo = new BuyVehicleFormPageVo();
            BeanUtils.copyProperties(buyVehicleForm,buyVehicleFormPageVo);
            if(comanyLeaderVoMap!=null) {
                BranComanyLeaderVo branComanyLeaderVo = comanyLeaderVoMap.get(buyVehicleForm.getCompanyId());
                buyVehicleFormPageVo.setLeaderName(branComanyLeaderVo == null ? "" : branComanyLeaderVo.getLeader());
                buyVehicleFormPageVo.setLeaderPhone(branComanyLeaderVo == null ? "" : branComanyLeaderVo.getLeaderContactInfo());
                buyVehicleFormPageVo.setCompanyName(branComanyLeaderVo == null ? "" : branComanyLeaderVo.getName());
            }
            buyVehicleFormPageVoList.add(buyVehicleFormPageVo);
        }

        buyVehicleFormPage.setData(buyVehicleFormPageVoList);
        buyVehicleFormPage.setPageSize(pageDataVO.getPageSize());
        buyVehicleFormPage.setPageNum(pageDataVO.getPageNum());
        buyVehicleFormPage.setTotalPage(pageDataVO.getTotalPage());
        buyVehicleFormPage.setTotalCount(pageDataVO.getTotalCount());
        return buyVehicleFormPage;
    }

    public void processApplyStatusById(Integer id) {
        mapper.updateApplyStatusById(id);
    }
}