package com.xxfc.platform.vehicle.biz;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.RandomUtil;
import com.github.wxiaoqi.security.common.vo.GoodDataVO;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.vehicle.constant.ResCode.ResCode;
import com.xxfc.platform.vehicle.entity.VehicleModel;
import com.xxfc.platform.vehicle.mapper.VehicleModelMapper;
import com.xxfc.platform.vehicle.pojo.VehicleModelQueryCondition;
import com.xxfc.platform.vehicle.pojo.VehicleModelVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.weekend.WeekendSqls;

import java.util.*;

/**
 * 车型
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-05-21 14:15:27
 */
@Service
@Slf4j
public class VehicleModelBiz extends BaseBiz<VehicleModelMapper, VehicleModel> {


    //添加评分
    public void addScore(Integer id, Integer score) {
        VehicleModel model = new VehicleModel();
        model.setId(id);
        model.setScore(score);
        updateSelectiveById(model);
    }

    /**
     * 分页查询车型列表
     * @param vmqc
     * @return
     */
    public ObjectRestResponse findVehicleModelPage(VehicleModelQueryCondition vmqc) {
        if (vmqc.getPathType()==2) {
            vmqc.setStatus(1);
        }
        try {
            PageDataVO<VehicleModelVo> mPageDataVO = PageDataVO.pageInfo(vmqc.getPage(),
                    vmqc.getLimit(), () -> mapper.findVehicleModelPage(vmqc));
            return ObjectRestResponse.succ(mPageDataVO);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return ObjectRestResponse.createFailedResult(ResCode.FIND_DATA_NOT_EXIST.getCode(), ResCode.FIND_DATA_NOT_EXIST.getDesc());

    }

    @Transactional
    public Integer insertAndGetId(VehicleModel vm) {
        try {
            mapper.insertSelective(vm);
            return vm.getId();
        } catch (Exception e) {
            e.printStackTrace();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
        }
        return null;
    }

    /**
     * 获取指定数量的随机车型
     * @return
     */
    public ObjectRestResponse findRandomVehicle(Integer number) {
        number = number == null ? 2 : number;
        VehicleModelQueryCondition vmqc = new VehicleModelQueryCondition();
        List<VehicleModelVo> list = mapper.findVehicleModelPage(vmqc);
        Set<VehicleModelVo> resultList = new HashSet<>();
        if(CollectionUtils.isNotEmpty(list)) {
            if(number >= list.size()) {
                return ObjectRestResponse.succ(list);
            }
            Set<Integer> set = new HashSet<>();
            RandomUtil.randomSet(list.size(), number, set, number);
            for(Integer i : set) {
               resultList.add(list.get(i));
            }
        }
        return ObjectRestResponse.succ(resultList);
    }

    /**
     *更新车型的评分
     * @param modelId
     * @param avgScore
     * @return
     */
    public int updateScoreByModelIdAndavgScore(Integer modelId, int avgScore) {
      return  mapper.updateScoreByModelIdAndavgScore(modelId,avgScore);
    }


    public void updateByPrimaryKeySelective(VehicleModel vm){
        mapper.updateByPrimaryKeySelective(vm);
    }

    /**
     * 分页查询返回List<GoodDataVO>
     * @param page
     * @param limit
     * @return
     */
    public List<GoodDataVO> goodList(Integer page, Integer limit) {
        List<GoodDataVO> goodDataVOS = new ArrayList<>();

        /*设置分页*/
        Page<VehicleModel> pages = PageHelper.startPage(page, limit);

        Example example = Example.builder(VehicleModel.class)
                .where(
                        WeekendSqls.<VehicleModel>custom()
                                .andEqualTo(VehicleModel::getIsdel, 0)
                                .andEqualTo(VehicleModel::getHotSign,1)
                ).orderByAsc("sort").build();
        List<VehicleModel> vehicleModels = selectByExample(example);
        if (CollectionUtils.isEmpty(vehicleModels)) {
            return null;
        }

        PageInfo<VehicleModel> pageInfo= PageInfo.of(vehicleModels);
        List<VehicleModel> vehicleModelList = pageInfo.getList();
        /*遍历车型列表设置List<GoodDataVO>*/
        vehicleModelList.forEach(vm ->{
            GoodDataVO goodDataVO = new GoodDataVO();
            goodDataVO.setId(vm.getId());
            goodDataVO.setImgUrl(vm.getPicture());
            goodDataVO.setName(vm.getName());
            goodDataVO.setName1(vm.getKeyword());
            goodDataVO.setPrice(String.valueOf(vm.getBuyPrice()));
            System.out.println("++++++++++++++++++++++++++++++++++++++"+goodDataVO+"++++++++++++++++++++++++++++++++++++++");
            goodDataVOS.add(goodDataVO);});
//        for (VehicleModel vm : vehicleModelList) {
//
//        }
        return goodDataVOS;
    }
}