package com.xxfc.platform.vehicle.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.order.contant.enumerate.OrderTypeEnum;
import com.xxfc.platform.order.entity.OrderRentVehicleDetail;
import com.xxfc.platform.order.entity.OrderTourDetail;
import com.xxfc.platform.order.feign.OrderFeign;
import com.xxfc.platform.order.pojo.order.OrderPageVO;
import com.xxfc.platform.vehicle.constant.ResCode.ResCode;
import com.xxfc.platform.vehicle.constant.VehicleCountType;
import com.xxfc.platform.vehicle.entity.VehicleBookRecord;
import com.xxfc.platform.vehicle.entity.VehicleCountRecord;
import com.xxfc.platform.vehicle.mapper.VehicleCountRecordMapper;
import com.xxfc.platform.vehicle.pojo.ExcelParamDto;
import com.xxfc.platform.vehicle.pojo.VehicleBookRecordVo;
import com.xxfc.platform.vehicle.util.excel.ExcelExport;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 统计出车，交车数量
 */
@Service
public class VehicleCountRecordBiz extends BaseBiz<VehicleCountRecordMapper, VehicleCountRecord> {

    public static final DateTimeFormatter DEFAULT_DATE_TIME_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd");
    public static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd HH:mm:ss");

    @Autowired
    VehicleBookRecordBiz vehicleBookRecordBiz;
    @Autowired
    VehicleDepartureService vehicleDepartureService;
    @Autowired
    OrderFeign orderFeign;

    /**
     * 获取统计出车记录
     *
     * @param vehicleCountRecord
     * @return
     */
    public ObjectRestResponse countDepartureVehicle(VehicleCountRecord vehicleCountRecord) {
        Map<String, Object> map = new HashMap<>();
        if (vehicleCountRecord.getType() != null) {
            map.put("type", vehicleCountRecord.getType());
        }
        if (StringUtils.isNotBlank(vehicleCountRecord.getStartTime())) {

            if (StringUtils.isBlank(vehicleCountRecord.getEndTime())) {
                vehicleCountRecord.setEndTime(vehicleCountRecord.getStartTime());
            }
            map.put("startTime", DateTime.parse(vehicleCountRecord.getStartTime(), DEFAULT_DATE_TIME_FORMATTER).toDate());
            map.put("endTime", DateTime.parse(vehicleCountRecord.getEndTime(), DEFAULT_DATE_TIME_FORMATTER).toDate());
        }

       if (MapUtils.isNotEmpty(map)) {
           List<VehicleCountRecord> list = mapper.selectByTypeAndTime(map);
           if (list == null) {
               return ObjectRestResponse.createFailedResult(ResCode.FIND_DATA_NOT_EXIST.getCode(), ResCode.FIND_DATA_NOT_EXIST.getDesc());
           }
           return ObjectRestResponse.succ(list);
       }
        return ObjectRestResponse.succ(new ArrayList<>());
    }

    /**
     * 添加统计记录
     *
     * @return
     */
    @Scheduled(cron = "59 59 23 * * ?")
    public void addAll() {
        Long nowTime = getDayStart();
        Long lastTime = nowTime + 24 * 3600 * 1000 - 1;
        Date startTime = new Date();
        startTime.setTime(nowTime);
        Date endTime = new Date();
        endTime.setTime(lastTime);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String startDate = null;
        String endDate = null;
        try {
            startDate = simpleDateFormat.format(startTime);
            endDate = simpleDateFormat.format(endTime);
        } catch (Exception e) {
            e.printStackTrace();
        }
        DateTime startDay = DateTime.parse(startDate, DEFAULT_DATE_TIME_FORMATTER);
        DateTime endDay = DateTime.parse(endDate, DEFAULT_DATE_TIME_FORMATTER);
        int i = 0;
        for (DateTime curDate = startDay; i < 30; curDate = curDate.minusDays(1)) {
            i++;
            nowTime = curDate.getMillis();
            lastTime = nowTime + 24 * 3600 * 1000 - 1;
            startTime.setTime(nowTime);
            endTime.setTime(lastTime);
            Date nowDate = curDate.toDate();
            VehicleCountRecord vehicleCountRecord = new VehicleCountRecord();
            VehicleCountRecord tourCountRecord = new VehicleCountRecord();
            VehicleCountRecord innerCountRecord = new VehicleCountRecord();
            //租车应出车数量
            List<OrderPageVO> vehicleDepartureList = orderFeign.getOrderList(nowTime, OrderTypeEnum.RENT_VEHICLE.getCode(), 1).getData();
            if (vehicleDepartureList != null && vehicleDepartureList.size() > 0) {
                vehicleCountRecord.setDepartureNum(vehicleDepartureList.size());
                List<OrderRentVehicleDetail> orderRentVehicleDetails = vehicleDepartureList.stream().map(OrderPageVO::getOrderRentVehicleDetail).collect(Collectors.toList());
                if (orderRentVehicleDetails != null && orderRentVehicleDetails.size() > 0) {
                    List<Long> bookRecordIds = orderRentVehicleDetails.stream().map(OrderRentVehicleDetail::getBookRecordId).collect(Collectors.toList());
                    if (bookRecordIds != null && bookRecordIds.size() > 0) {
                        List<VehicleBookRecordVo> vehicleBookRecordVos = vehicleBookRecordBiz.selectByIds(bookRecordIds).getData();
                        if (vehicleBookRecordVos != null && vehicleBookRecordVos.size() > 0) {
                            Map<Integer, Integer> map = getDeparture(vehicleBookRecordVos, 1);
                            if (MapUtils.isNotEmpty(map)) {
                                // 租车提前交车数量 已经还车且交车时间小于出车时间，
                                vehicleCountRecord.setBeforeDepartureNum(map.get(2));
                                //延后交车，还未交车
                                vehicleCountRecord.setAfterDepartureNum(map.get(1));
                                //正常交车，在当天时间内交车
                                vehicleCountRecord.setActualDepartureNum(map.get(3));
                            }
                        }

                    }
                }
            }
            vehicleCountRecord.setType(VehicleCountType.RENT_VEHICLE.getCode());
            //旅游应出车数量
            List<OrderPageVO> tourDepartureList = orderFeign.getOrderList(nowTime, OrderTypeEnum.TOUR.getCode(), 1).getData();
            if (tourDepartureList != null && tourDepartureList.size() > 0) {
                tourCountRecord.setDepartureNum(tourDepartureList.size());
                tourCountRecord.setActualDepartureNum(tourDepartureList.size());
            }
            tourCountRecord.setType(VehicleCountType.TOUR.getCode());
            //内部用车应出车数量
            List<VehicleBookRecordVo> vehicleDepartureBookRecordList = vehicleBookRecordBiz.selectAllBookRecord(startTime, endTime, 1).getData();
            if (vehicleDepartureBookRecordList != null && vehicleDepartureBookRecordList.size() > 0) {
                innerCountRecord.setDepartureNum(vehicleDepartureBookRecordList.size());
                Map<Integer, Integer> map = getDeparture(vehicleDepartureBookRecordList, 1);
                if (MapUtils.isNotEmpty(map)) {
                    // 租车提前交车数量 已经出车且交车时间小于出车时间，
                    innerCountRecord.setBeforeDepartureNum(map.get(2));
                    //延后交车，还未交车
                    innerCountRecord.setAfterDepartureNum(map.get(1));
                    //正常交车，在当天时间内交车
                    innerCountRecord.setActualDepartureNum(map.get(3));
                }
            }
            innerCountRecord.setType(VehicleCountType.INNER.getCode());


            //租车应还车数量
            List<OrderPageVO> vehicleArrivalList = orderFeign.getOrderList(nowTime, OrderTypeEnum.RENT_VEHICLE.getCode(), 2).getData();
            if (vehicleArrivalList != null && vehicleArrivalList.size() > 0) {
                vehicleCountRecord.setArrivalNum(vehicleArrivalList.size());
                List<OrderRentVehicleDetail> orderRentVehicleDetails = vehicleDepartureList.stream().map(OrderPageVO::getOrderRentVehicleDetail).collect(Collectors.toList());
                if (orderRentVehicleDetails != null && orderRentVehicleDetails.size() > 0) {
                    List<Long> bookRecordIds = orderRentVehicleDetails.stream().map(OrderRentVehicleDetail::getBookRecordId).collect(Collectors.toList());
                    if (bookRecordIds != null && bookRecordIds.size() > 0) {
                        List<VehicleBookRecordVo> vehicleBookRecordVos = vehicleBookRecordBiz.selectByIds(bookRecordIds).getData();
                        if (vehicleBookRecordVos != null && vehicleBookRecordVos.size() > 0) {
                            Map<Integer, Integer> map = getDeparture(vehicleBookRecordVos, 2);
                            if (MapUtils.isNotEmpty(map)) {
                                // 租车提前还车数量 已经出车且还车时间小于还车时间，
                                vehicleCountRecord.setBeforeArrivalNum(map.get(2));
                                //延后还车，还未还车
                                vehicleCountRecord.setAfterArrivalNum(map.get(1));
                                //正常还车，在当天时间内还车
                                vehicleCountRecord.setActualArrivalNum(map.get(3));
                            }
                        }

                    }
                }
            }
            //旅游应还车数量
            List<OrderPageVO> tourArrivalList = orderFeign.getOrderList(nowTime, OrderTypeEnum.TOUR.getCode(), 2).getData();
            if (tourArrivalList != null && tourArrivalList.size() > 0) {
                tourCountRecord.setArrivalNum(tourArrivalList.size());
                tourCountRecord.setActualArrivalNum(tourArrivalList.size());
            }
            //内部用车应还车数量
            List<VehicleBookRecordVo> vehicleArrivalBookRecordList = vehicleBookRecordBiz.selectAllBookRecord(startTime, endTime, 1).getData();
            if (vehicleArrivalBookRecordList != null && vehicleArrivalBookRecordList.size() > 0) {
                innerCountRecord.setArrivalNum(vehicleArrivalBookRecordList.size());
                Map<Integer, Integer> map = getDeparture(vehicleDepartureBookRecordList, 2);
                if (MapUtils.isNotEmpty(map)) {
                    // 租车提前交车数量 已经出车且还车时间小于还车时间，
                    innerCountRecord.setBeforeArrivalNum(map.get(2));
                    //延后还车，还未还车
                    innerCountRecord.setAfterArrivalNum(map.get(1));
                    //正常还车，在当天时间内还车
                    innerCountRecord.setActualArrivalNum(map.get(3));
                }
            }

            vehicleCountRecord.setCountDate(nowDate);
            tourCountRecord.setCountDate(nowDate);
            innerCountRecord.setCountDate(nowDate);
            save(vehicleCountRecord);
            save(tourCountRecord);
            save(innerCountRecord);
        }

    }

    /**
     * 添加统计记录
     *
     * @return
     */
    public void add() {
        Long nowTime = getDayStart();
        Long lastTime = nowTime + 24 * 3600 * 1000 - 1;
        Date startTime = new Date();
        startTime.setTime(nowTime);
        Date endTime = new Date();
        endTime.setTime(lastTime);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String startDate = null;
        try {
            startDate = simpleDateFormat.format(startTime);
        } catch (Exception e) {
            e.printStackTrace();
        }
        DateTime startDay = DateTime.parse(startDate, DEFAULT_DATE_TIME_FORMATTER);
        Date nowDate = startDay.toDate();
        VehicleCountRecord vehicleCountRecord = new VehicleCountRecord();
        VehicleCountRecord tourCountRecord = new VehicleCountRecord();
        VehicleCountRecord innerCountRecord = new VehicleCountRecord();
        //租车应出车数量
        List<OrderPageVO> vehicleDepartureList = orderFeign.getOrderList(nowTime, OrderTypeEnum.RENT_VEHICLE.getCode(), 1).getData();
        if (vehicleDepartureList != null && vehicleDepartureList.size() > 0) {
            vehicleCountRecord.setDepartureNum(vehicleDepartureList.size());
            List<OrderRentVehicleDetail> orderRentVehicleDetails = vehicleDepartureList.stream().map(OrderPageVO::getOrderRentVehicleDetail).collect(Collectors.toList());
            if (orderRentVehicleDetails != null && orderRentVehicleDetails.size() > 0) {
                List<Long> bookRecordIds = orderRentVehicleDetails.stream().map(OrderRentVehicleDetail::getBookRecordId).collect(Collectors.toList());
                if (bookRecordIds != null && bookRecordIds.size() > 0) {
                    List<VehicleBookRecordVo> vehicleBookRecordVos = vehicleBookRecordBiz.selectByIds(bookRecordIds).getData();
                    if (vehicleBookRecordVos != null && vehicleBookRecordVos.size() > 0) {
                        Map<Integer, Integer> map = getDeparture(vehicleBookRecordVos, 1);
                        if (MapUtils.isNotEmpty(map)) {
                            // 租车提前交车数量 已经还车且交车时间小于出车时间，
                            vehicleCountRecord.setBeforeDepartureNum(map.get(2));
                            //延后交车，还未交车
                            vehicleCountRecord.setAfterDepartureNum(map.get(1));
                            //正常交车，在当天时间内交车
                            vehicleCountRecord.setActualDepartureNum(map.get(3));
                        }
                    }

                }
            }
        }
        vehicleCountRecord.setType(VehicleCountType.RENT_VEHICLE.getCode());
        //旅游应出车数量
        List<OrderPageVO> tourDepartureList = orderFeign.getOrderList(nowTime, OrderTypeEnum.TOUR.getCode(), 1).getData();
        if (tourDepartureList != null && tourDepartureList.size() > 0) {
            tourCountRecord.setDepartureNum(tourDepartureList.size());
            tourCountRecord.setActualDepartureNum(tourDepartureList.size());
        }
        tourCountRecord.setType(VehicleCountType.TOUR.getCode());
        //内部用车应出车数量
        List<VehicleBookRecordVo> vehicleDepartureBookRecordList = vehicleBookRecordBiz.selectAllBookRecord(startTime, endTime, 1).getData();
        if (vehicleDepartureBookRecordList != null && vehicleDepartureBookRecordList.size() > 0) {
            innerCountRecord.setDepartureNum(vehicleDepartureBookRecordList.size());
            Map<Integer, Integer> map = getDeparture(vehicleDepartureBookRecordList, 1);
            if (MapUtils.isNotEmpty(map)) {
                // 租车提前交车数量 已经出车且交车时间小于出车时间，
                innerCountRecord.setBeforeDepartureNum(map.get(2));
                //延后交车，还未交车
                innerCountRecord.setAfterDepartureNum(map.get(1));
                //正常交车，在当天时间内交车
                innerCountRecord.setActualDepartureNum(map.get(3));
            }
        }
        innerCountRecord.setType(VehicleCountType.INNER.getCode());


        //租车应还车数量
        List<OrderPageVO> vehicleArrivalList = orderFeign.getOrderList(nowTime, OrderTypeEnum.RENT_VEHICLE.getCode(), 2).getData();
        if (vehicleArrivalList != null && vehicleArrivalList.size() > 0) {
            vehicleCountRecord.setArrivalNum(vehicleArrivalList.size());
            List<OrderRentVehicleDetail> orderRentVehicleDetails = vehicleDepartureList.stream().map(OrderPageVO::getOrderRentVehicleDetail).collect(Collectors.toList());
            if (orderRentVehicleDetails != null && orderRentVehicleDetails.size() > 0) {
                List<Long> bookRecordIds = orderRentVehicleDetails.stream().map(OrderRentVehicleDetail::getBookRecordId).collect(Collectors.toList());
                if (bookRecordIds != null && bookRecordIds.size() > 0) {
                    List<VehicleBookRecordVo> vehicleBookRecordVos = vehicleBookRecordBiz.selectByIds(bookRecordIds).getData();
                    if (vehicleBookRecordVos != null && vehicleBookRecordVos.size() > 0) {
                        Map<Integer, Integer> map = getDeparture(vehicleBookRecordVos, 2);
                        if (MapUtils.isNotEmpty(map)) {
                            // 租车提前还车数量 已经出车且还车时间小于还车时间，
                            vehicleCountRecord.setBeforeArrivalNum(map.get(2));
                            //延后还车，还未还车
                            vehicleCountRecord.setAfterArrivalNum(map.get(1));
                            //正常还车，在当天时间内还车
                            vehicleCountRecord.setActualArrivalNum(map.get(3));
                        }
                    }

                }
            }
        }
        //旅游应还车数量
        List<OrderPageVO> tourArrivalList = orderFeign.getOrderList(nowTime, OrderTypeEnum.TOUR.getCode(), 2).getData();
        if (tourArrivalList != null && tourArrivalList.size() > 0) {
            tourCountRecord.setArrivalNum(tourArrivalList.size());
            tourCountRecord.setActualArrivalNum(tourArrivalList.size());
        }
        //内部用车应还车数量
        List<VehicleBookRecordVo> vehicleArrivalBookRecordList = vehicleBookRecordBiz.selectAllBookRecord(startTime, endTime, 1).getData();
        if (vehicleArrivalBookRecordList != null && vehicleArrivalBookRecordList.size() > 0) {
            innerCountRecord.setArrivalNum(vehicleArrivalBookRecordList.size());
            Map<Integer, Integer> map = getDeparture(vehicleDepartureBookRecordList, 2);
            if (MapUtils.isNotEmpty(map)) {
                // 租车提前交车数量 已经出车且还车时间小于还车时间，
                innerCountRecord.setBeforeArrivalNum(map.get(2));
                //延后还车，还未还车
                innerCountRecord.setAfterArrivalNum(map.get(1));
                //正常还车，在当天时间内还车
                innerCountRecord.setActualArrivalNum(map.get(3));
            }
        }

        vehicleCountRecord.setCountDate(nowDate);
        tourCountRecord.setCountDate(nowDate);
        innerCountRecord.setCountDate(nowDate);
        save(vehicleCountRecord);
        save(tourCountRecord);
        save(innerCountRecord);
    }

    public void save(VehicleCountRecord vehicleCountRecord) {
        if (vehicleCountRecord != null) {
            Map<String, Object> map = new HashMap<>();
            map.put("type", vehicleCountRecord.getType());
            map.put("startTime", getDayStart(vehicleCountRecord.getCountDate().getTime()));
            map.put("endTime", getDayStart(vehicleCountRecord.getCountDate().getTime()) + 24 * 3600 * 1000);
            List<VehicleCountRecord> list = mapper.selectByTypeAndTime(map);
            if (list != null && list.size() > 0) {
                BeanUtil.copyProperties(vehicleCountRecord, list.get(0), CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
                updateByIdRe(list.get(0));
            } else {
                insertSelective(vehicleCountRecord);
            }
        }
    }

    public String export(ExcelParamDto excelParamDto) {
        ExcelExport ee1 = new ExcelExport();
        ee1.addSheetByArray(excelParamDto.getName(), excelParamDto.getData(), excelParamDto.getHeader());
        String fileName = "/data/temp/"+ excelParamDto.getName() + ".xlsx";
        OutputStream fis;
        try {
            fis = new FileOutputStream(fileName);
            ee1.getWorkbook().write(fis);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return fileName;
    }

    public void download(String path, HttpServletResponse response) {
        try {
            // path是指欲下载的文件的路径。
            File file = new File(path);
            // 取得文件名。
            String filename = file.getName();
            // 取得文件的后缀名。
            String ext = filename.substring(filename.lastIndexOf(".") + 1).toUpperCase();

            // 以流的形式下载文件。
            InputStream fis = new BufferedInputStream(new FileInputStream(path));
            byte[] buffer = new byte[fis.available()];
            fis.read(buffer);
            fis.close();
            // 清空response
            response.reset();
            // 设置response的Header
            response.addHeader("Content-Disposition", "attachment;filename=" + new String(filename.getBytes()));
            response.addHeader("Content-Length", "" + file.length());
            OutputStream toClient = new BufferedOutputStream(response.getOutputStream());
            response.setContentType("application/octet-stream");
            toClient.write(buffer);
            toClient.flush();
            toClient.close();
        } catch (IOException ex) {
            ex.printStackTrace();
        }
    }


    public Map<Integer, Integer> getDeparture(List<VehicleBookRecordVo> list, Integer type) {
        Map<Integer, Integer> map = new HashMap<>();
        Integer a = 0;
        Integer b = 0;
        Integer c = 0;
        for (VehicleBookRecordVo vehicleBookRecordVo : list) {
            //延后交车
            if (type == 1) {
                if (vehicleBookRecordVo.getVehicleDepartureLogVo() == null) {
                    a++;
                    //提前交车
                } else if (vehicleBookRecordVo.getVehicleDepartureLogVo() != null && DateTime.parse(vehicleBookRecordVo.getVehicleDepartureLogVo().getDepartureTime(), DATE_TIME_FORMATTER).getMillis() < getDayStart(vehicleBookRecordVo.getBookStartDate().getTime())) {
                    b++;
                    //正常交车
                } else if (vehicleBookRecordVo.getVehicleDepartureLogVo() != null && DateTime.parse(vehicleBookRecordVo.getVehicleDepartureLogVo().getDepartureTime(), DATE_TIME_FORMATTER).getMillis() >= getDayStart(vehicleBookRecordVo.getBookStartDate().getTime()) && DateTime.parse(vehicleBookRecordVo.getVehicleDepartureLogVo().getDepartureTime(), DATE_TIME_FORMATTER).getMillis() <= getDayStart(vehicleBookRecordVo.getBookStartDate().getTime()) + 24 * 3600 * 1000 - 1) {
                    c++;
                }
            } else if (type == 2) {
                //延后还车
                if (vehicleBookRecordVo.getVehicleDepartureLogVo() != null && vehicleBookRecordVo.getVehicleDepartureLogVo().getState() == 1 && DateTime.parse(vehicleBookRecordVo.getVehicleDepartureLogVo().getArrivalTime(), DATE_TIME_FORMATTER).getMillis() > getDayStart(vehicleBookRecordVo.getBookEndDate().getTime()) + 24 * 3600 * 1000 - 1) {
                    a++;
                    //提前还车
                } else if (vehicleBookRecordVo.getVehicleDepartureLogVo() != null && vehicleBookRecordVo.getVehicleDepartureLogVo().getState() == 1 && DateTime.parse(vehicleBookRecordVo.getVehicleDepartureLogVo().getArrivalTime(), DATE_TIME_FORMATTER).getMillis() < getDayStart(vehicleBookRecordVo.getBookEndDate().getTime())) {
                    b++;
                    //正常还车
                } else if (vehicleBookRecordVo.getVehicleDepartureLogVo() != null && vehicleBookRecordVo.getVehicleDepartureLogVo().getState() == 1 && DateTime.parse(vehicleBookRecordVo.getVehicleDepartureLogVo().getArrivalTime(), DATE_TIME_FORMATTER).getMillis() >= getDayStart(vehicleBookRecordVo.getBookEndDate().getTime()) && DateTime.parse(vehicleBookRecordVo.getVehicleDepartureLogVo().getArrivalTime(), DATE_TIME_FORMATTER).getMillis() <= getDayStart(vehicleBookRecordVo.getBookEndDate().getTime()) + 24 * 3600 * 1000 - 1) {
                    c++;
                }
            }

        }
        map.put(1, a);
        map.put(2, b);
        map.put(3, c);
        return map;
    }

    public static Long getDayStart() {
        long current = System.currentTimeMillis();
        long zero = current / (1000 * 3600 * 24) * (1000 * 3600 * 24) - TimeZone.getDefault().getRawOffset();
        return zero;
    }

    public static Long getDayStart(Long time) {
        long current = time;
        long zero = current / (1000 * 3600 * 24) * (1000 * 3600 * 24) - TimeZone.getDefault().getRawOffset();
        return zero;
    }
}
