package com.xxfc.platform.activity.biz;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.activity.entity.ActivityProduct;
import com.xxfc.platform.activity.entity.ActivityProductSpecs;
import com.xxfc.platform.activity.mapper.ActivityProductMapper;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import tk.mybatis.mapper.entity.Example;

import java.util.List;

@Service
@Slf4j
@Api("活动商品")
public class ActivityProductBiz extends BaseBiz<ActivityProductMapper, ActivityProduct> {

	@Autowired
	ActivityProductSpecsBiz activityProductSpecsBiz;

	/**
	 * 添加活动商品
	 * @param activityProduct
	 * @return
	 */
	public ObjectRestResponse add(ActivityProduct activityProduct) {
		if (activityProduct == null) {
			return ObjectRestResponse.paramIsEmpty();
		}
		//新增
		if (activityProduct.getId() == null) {
			insertSelectiveRe(activityProduct);
		} else { //修改
			ActivityProduct oldValue = getOne(activityProduct.getId());
			BeanUtil.copyProperties(activityProduct, oldValue, CopyOptions.create().setIgnoreNullValue(true).setIgnoreError(true));
			updateSelectiveByIdRe(oldValue);
			return ObjectRestResponse.succ(oldValue);
		}
		return ObjectRestResponse.succ(activityProduct);
	}

	public ActivityProduct getOne(Long id) {
		Example example = new Example(ActivityProduct.class);
		example.createCriteria().andEqualTo("id", id).andEqualTo("isDel", false);
		ActivityProduct activityProduct = mapper.selectOneByExample(example);
		if(activityProduct != null) {
			List<ActivityProductSpecs> activityProductSpecs = activityProductSpecsBiz.getAllByActiveId(activityProduct.getId());
			activityProduct.setList(activityProductSpecs);
		}
		return activityProduct;
	}

	public ObjectRestResponse update(ActivityProduct activityProduct) {
		if (activityProduct == null || activityProduct.getId() == null) {
			return ObjectRestResponse.paramIsEmpty();
		}
		ActivityProduct oldValue = selectById(activityProduct.getId());
		if (oldValue != null) { //增加销量，减少库存
			oldValue.setSales(oldValue.getSales() + activityProduct.getSales());
			oldValue.setStock(oldValue.getStock() - activityProduct.getSales());
			updateSelectiveByIdRe(oldValue);
			return ObjectRestResponse.succ(oldValue);
		} else {
			return ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE, "商品不存在！");
		}
	}


	public List<ActivityProduct> getAll() {
		Example example = new Example(ActivityProduct.class);
		example.createCriteria().andEqualTo("status", true).andEqualTo("isDel", false);
		List<ActivityProduct> list = mapper.selectByExample(example);
		if (list != null && list.size() > 0) {
			list.parallelStream().forEach(activityProduct -> {
				List<ActivityProductSpecs> activityProductSpecs = activityProductSpecsBiz.getAllByActiveId(activityProduct.getId());
				activityProduct.setList(activityProductSpecs);
			});
		}
		return list;
	}

}
