package com.xxfc.platform.order.jobhandler;

import cn.hutool.core.date.DateUtil;
import com.github.wxiaoqi.security.admin.feign.UserFeign;
import com.xxfc.platform.order.biz.*;
import com.xxfc.platform.order.biz.inner.OrderMsgBiz;
import com.xxfc.platform.order.contant.enumerate.*;
import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.entity.OrderRentVehicleDetail;
import com.xxfc.platform.order.entity.OrderVehicleCrosstown;
import com.xxfc.platform.order.entity.OrderViolation;
import com.xxfc.platform.order.pojo.account.OrderAccountDeduction;
import com.xxfc.platform.order.pojo.account.OrderAccountDetail;
import com.xxfc.platform.universal.constant.DictionaryKey;
import com.xxfc.platform.universal.entity.Dictionary;
import com.xxfc.platform.universal.feign.ThirdFeign;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.handler.IJobHandler;
import com.xxl.job.core.handler.annotation.JobHandler;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.weekend.WeekendSqls;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_FALSE;
import static com.github.wxiaoqi.security.common.constant.CommonConstants.SYS_TRUE;
import static com.xxfc.platform.universal.constant.DictionaryKey.APP_ORDER;

/**
 * 跨平台Http任务
 *
 * @author xuxueli 2018-09-16 03:48:34
 */
@JobHandler(value = "rentDepositHandler")
@Component
@Slf4j
public class RentDepositJobHandler extends IJobHandler {

    @Autowired
    BaseOrderBiz baseOrderBiz;

    @Autowired
    OrderRentVehicleBiz orderRentVehicleBiz;

    @Autowired
    OrderVehicleCrosstownBiz crosstownBiz;

    @Autowired
    OrderDepositRefundRecordBiz orderDepositRefundRecordBiz;

    @Autowired
    OrderViolationBiz orderViolationBiz;

    @Autowired
    OrderAccountBiz orderAccountBiz;

    @Autowired
    OrderMsgBiz orderMsgBiz;

    @Autowired
    ThirdFeign thirdFeign;

    @Autowired
    UserFeign userFeign;

    @Override
    public ReturnT<String> execute(String idLastNumInterval) {
        Map<String, Dictionary> dictionaryMap = thirdFeign.dictionaryGetAll4Map().getData();
        Long rentDepositAutoRefundTime = new Long(dictionaryMap.get(APP_ORDER+ "_"+ DictionaryKey.RENT_DEPOSIT_AUTO_REFUND_TIME).getDetail());

        try {
            List<BaseOrder> lists = baseOrderBiz.selectByExample(new Example.Builder(BaseOrder.class)
                //订单已完成的租车订单
                .where(WeekendSqls.<BaseOrder>custom().andEqualTo(BaseOrder::getType, OrderTypeEnum.RENT_VEHICLE.getCode())
                        .andEqualTo(BaseOrder::getStatus, OrderStatusEnum.ORDER_FINISH.getCode()) //已完成的订单
                        .andEqualTo(BaseOrder::getRefundStatus, RefundStatusEnum.RESIDUE_ILLEGAL.getCode()) //已归还了部分押金
                        .andLessThanOrEqualTo(BaseOrder::getCrtTime, DateUtil.date(System.currentTimeMillis() - (rentDepositAutoRefundTime * 60L * 1000L)))
//                                    .andLike(BaseOrder::getId, "%"+ i)
                ).build());

            //处理自动退剩余押金
            for(BaseOrder baseOrder : lists) {
                OrderRentVehicleDetail orvd = orderRentVehicleBiz.selectOne(new OrderRentVehicleDetail() {{
                    setOrderId(baseOrder.getId());
                }});

                Integer crosstownTypeEnum;
                //判断是否定损过
                if(SYS_TRUE.equals(orvd.getFixedLossStatus())) {
                    crosstownTypeEnum = CrosstownTypeEnum.FIXED_LOSS.getCode();
                }else {
                    crosstownTypeEnum = CrosstownTypeEnum.ARRIVE.getCode();
                }
                OrderVehicleCrosstown crosstown = crosstownBiz.selectOne(new OrderVehicleCrosstown(){{
                    setOrderId(baseOrder.getId());
                    setType(crosstownTypeEnum);
                }});

                if(crosstown.getCrtTime().compareTo(System.currentTimeMillis() - (rentDepositAutoRefundTime * 60L * 1000L)) < 0) {
                    OrderViolation orderViolation = orderViolationBiz.selectOne(new OrderViolation(){{
                        setDetailId(orvd.getId());
                        setIsDel(SYS_FALSE);
                    }});

                    OrderAccountDetail oad = new OrderAccountDetail();

                    String refundDesc = "退还押金：";
                    BigDecimal refundAmont;
                    if(null != orderViolation) {
                        //设置扣款项
                        oad.getDeductions().add(
                                orderAccountBiz.initDeduction(orderViolation.getPrice(), DeductionTypeEnum.VIOLATE_TRAFFIC_DEDUCT.getDesc(), DeductionTypeEnum.VIOLATE_TRAFFIC_DEDUCT, OrderAccountDeduction.ORIGIN_DEPOSIT)
                        );

                        //还车扣除款 剩余的 钱，再减去违章预备金
                        refundAmont = orvd.getReturnPayResidue().subtract(orderViolation.getPrice());
                        refundDesc += refundAmont.toString()+ "(已扣除 违章扣款："+ refundAmont.toString();
                        refundDesc += ")";
                    }else {
                        refundAmont = orvd.getReturnPayResidue();
                        refundDesc += refundAmont.toString();
                    }
                    oad.setOriginDepositAmount(orvd.getReturnPayResidue());
                    oad.setDepositAmount(refundAmont);
                    orderAccountBiz.refundTrigger(baseOrder, orvd, BigDecimal.ZERO, orvd.getReturnPayResidue(), refundAmont, refundDesc, RefundStatusEnum.REFUND_DEPOSIT.getCode(), AccountTypeEnum.OUT_RESIDUE_DEPOSIT, oad);
                    orderDepositRefundRecordBiz.completeRecordStatus(crosstown.getId(), DepositRefundStatus.VIOLATIONARRIVAL);
                    orderMsgBiz.handelMsgDeposit(orvd, baseOrder, userFeign.userDetailById(baseOrder.getUserId()).getData());
                }

            }

            return ReturnT.SUCCESS;
        } catch (Exception e) {
            XxlJobLogger.log(e);
            return FAIL;
        } finally {
            ;
        }
    }

}