package com.xxfc.platform.vehicle.feign.dto;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Data
public class UserDTO {
    private Integer id;

    private String username;

    private String password;

    private String name;

    private String birthday;

    private String address;

    private String mobilePhone;

    private String telPhone;

    private String email;

    private String sex;

    private String type;

    private Integer status;

    private String description;

    private Date crtTime;

    private String crtUser;

    private String crtName;

    private String crtHost;

    private Date updTime;

    private String updUser;

    private String updName;

    private String updHost;

    private Integer dataAll;

    private String dataZone;

    private String dataCompany;

    public List<Integer> dataZone2List() {
        return str2List(this.dataZone);
    }

    public List<Integer> dataCompany2List() {
        return str2List(this.dataCompany);
    }

    private List<Integer> str2List(String str) {
        if(StringUtils.isNotBlank(str)) {
            return Arrays.asList(str.split(",")).parallelStream().map(s -> Integer.valueOf(s)).collect(Collectors.toList());
        }else {
            return new ArrayList<Integer>();
        }
    }

}