package com.xxfc.platform.order.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.lang.Dict;
import cn.hutool.extra.template.Template;
import cn.hutool.extra.template.TemplateConfig;
import cn.hutool.extra.template.TemplateEngine;
import cn.hutool.extra.template.TemplateUtil;
import com.xxfc.platform.order.biz.OrderCostDetailBiz;
import com.xxfc.platform.order.biz.OrderRentVehicleBiz;
import com.xxfc.platform.order.contant.enumerate.OrderCostEnum;
import com.xxfc.platform.order.contant.enumerate.OrderStatusEnum;
import com.xxfc.platform.order.contant.enumerate.OrderTypeEnum;
import com.xxfc.platform.order.entity.OrderCostDetail;
import com.xxfc.platform.order.vo.order.RentVehicleBO;
import com.xxfc.platform.order.vo.price.OrderPriceVO;
import com.xxfc.platform.order.vo.price.RentVehiclePriceVO;
import com.xxfc.platform.vehicle.entity.VehicleModel;
import com.xxfc.platform.vehicle.feign.VehicleFeign;
import lombok.extern.log4j.Log4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.math.BigDecimal;

@Service
@Log4j
public class OrderRentVehicleService extends AbstractOrderHandle<OrderRentVehicleBiz, RentVehicleBO> {

    private static BigDecimal DRIVER_PRICE = new BigDecimal("600.00");
    private static Integer DRIVER_TYPE_COMPANY = 1;
    private static BigDecimal DEPOSIT = new BigDecimal("20000.00");

    @Autowired
    VehicleFeign vehicleFeign;

    @Autowired
    OrderCostDetailBiz orderCostDetailBiz;

    @PostConstruct
    public void init(){
        this.orderTypeEnum = OrderTypeEnum.RentVehicle;
    }


    @Override
    public void initDetail(RentVehicleBO bo) {
        super.initDetail(bo);
        VehicleModel vehicleModel = vehicleFeign.get(bo.getModelId()).getData();
        bo.setVehicleModel(vehicleModel);
    }

    @Override
    public void handleDetail(RentVehicleBO bo) {
        //获取可用车辆
        acquireVehicle(bo);
        //设置订单状态为3
        bo.getOrder().setStatus(OrderStatusEnum.ORDER_UNPAY.getCode());
        //设置订单图片
        bo.getOrder().setPicture(bo.getVehicleModel().getPicture());
        //设置订单名称
        bo.getOrder().setName(bo.getVehicleModel().getName());

        super.handleDetail(bo);
    }

    @Override
    public void handleCalculate(RentVehicleBO bo) {
        RentVehiclePriceVO rvpv = calculatePrice(bo);
        BeanUtil.copyProperties(rvpv, bo.getOrder());
        BeanUtil.copyProperties(rvpv, bo);
    }

    @Override
    public RentVehiclePriceVO calculatePrice(RentVehicleBO detail) {
        BigDecimal orderAmount = BigDecimal.ZERO;
        BigDecimal goodsAmount = BigDecimal.ZERO;
        BigDecimal vehicleAmount = BigDecimal.ZERO;
        BigDecimal driverAmount = BigDecimal.ZERO;

        //计算价格
            //计算车辆费用
        VehicleModel vehicleModel = vehicleFeign.get(detail.getModelId()).getData();
        vehicleAmount = vehicleAmount.add(vehicleModel.getPrice().multiply(BigDecimal.valueOf(detail.getDayNum())));
        if(DRIVER_TYPE_COMPANY.equals(detail.getDriverType())) {
            //计算司机费用
            driverAmount = driverAmount.add(DRIVER_PRICE.multiply(BigDecimal.valueOf(detail.getDayNum())));
        }
            //商品价格
        goodsAmount = goodsAmount.add(vehicleAmount).add(driverAmount);
            //总价格（包含押金）
        orderAmount = orderAmount.add(goodsAmount).add(DEPOSIT);

        //生成订单明细
        RentVehiclePriceVO rvp = new RentVehiclePriceVO();
        rvp.setOrderAmount(orderAmount);
        rvp.setGoodsAmount(goodsAmount);
        rvp.setDriverAmount(driverAmount);
        rvp.setVehicleAmount(vehicleAmount);
        rvp.setRealAmount(orderAmount);
        rvp.setDeposit(DEPOSIT);
        rvp.setModelAmount(vehicleModel.getPrice());
        rvp.setDriverPrice(DRIVER_PRICE);
        rvp.setModelName(vehicleModel.getName());
        rvp.setDayNum(detail.getDayNum());
        rvp.setVehicleNum(1);
        rvp.setDriverNum(1);

        detail.setCostDetail(costDetail(rvp));
        return rvp;
    }

    /**
     * 计算费用明细
     * @param vo
     * @return
     */
    private String costDetail(RentVehiclePriceVO vo) {
        TemplateEngine engine = TemplateUtil.createEngine(new TemplateConfig());
        OrderCostDetail orderCostDetail = orderCostDetailBiz.selectById(OrderCostEnum.RentVehicle.getCode());
        Template template = engine.getTemplate(orderCostDetail.getTemplate());
        String result = template.render(Dict.parse(vo));
        vo.setCostDetail(result);
        return result;
    }

    private String acquireVehicle(RentVehicleBO detail) {
        //根据车型、时间、距离，门店，预定车辆
        String vehicleId =  "0e9a88db-cb1b-48a4-b307-40f89eed906f";
        detail.setVehicleId(vehicleId);
        return vehicleId;
    }
}
