package com.xxfc.platform.order.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.IdUtil;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.context.BaseContextHandler;
import com.github.wxiaoqi.security.common.exception.BaseException;
import com.github.wxiaoqi.security.common.util.OrderUtil;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.xxfc.platform.order.biz.BaseOrderBiz;
import com.xxfc.platform.order.contant.enumerate.OrderStatusEnum;
import com.xxfc.platform.order.contant.enumerate.OrderTypeEnum;
import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.entity.inter.OrderDetail;
import com.xxfc.platform.order.vo.price.OrderPriceVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;

@Transactional
public abstract class AbstractOrderHandle<Biz extends BaseBiz, Detail extends OrderDetail>{

    @Autowired
    protected Biz detailBiz;

    @Autowired
    protected BaseOrderBiz baseOrderBiz;

    protected OrderTypeEnum orderTypeEnum;

    /**
     * 创建基础订单
     * @return
     */
    public BaseOrder createBaseOrder() {
        BaseOrder baseOrder = new BaseOrder();
        //设置订单号
        baseOrder.setNo(OrderUtil.GetOrderNumber("", OrderUtil.APP_MID));
        //设置订单类型
        if(null == orderTypeEnum)
            throw new BaseException(ResultCode.NOTEXIST_CODE);
        else {
            baseOrder.setType(orderTypeEnum.getCode());
        }
        //设置订单状态
        baseOrder.setStatus(OrderStatusEnum.ORDER_CRT.getCode());

        //设置用户id
        baseOrder.setUserId(Integer.valueOf(BaseContextHandler.getUserID()));
        return baseOrder;
    }

    public void initDetail(Detail detail) {
        BaseOrder order = createBaseOrder();
        detail.setOrder(order);
    }

    /**
     * 创建订单及其子项
     * @param detail
     */
    public void createOrder(Detail detail) {
        //初始化
        initDetail(detail);
        //计算价格
        handleCalculate(detail);
        //插入baseOrder
        baseOrderBiz.insertSelective(detail.getOrder());
        //处理detail
        handleDetail(detail);
    }

    /**
     * 处理订单详情
     * @param detail
     */
    public void handleDetail(Detail detail){
        detail.setOrderId(detail.getOrder().getId());
        detailBiz.insertSelective(detail);
        detail.getOrder().setDetailId(detail.getId());
        baseOrderBiz.updateById(detail.getOrder());
    }

//    /**
//     * 创建订单及其多子项
//     * @param details
//     */
//    public void createOrder(List<Detail> details) {
//        BaseOrder order = createOrder();
//        for(Detail detail : details) {
//            preHandleDetail(order, detail);
//        }
//        handleDetail(details);
//    }
//
//    /**
//     * 处理订单多子项
//     * @param details
//     */
//    public void handleDetail(List<Detail> details){
//        for(Detail detail : details) {
//            detailBiz.insertSelective(detail);
//        }
//    }

    /**
     * 计算价格
     * @param detail
     */
    public OrderPriceVO calculatePrice(Detail detail) {
        OrderPriceVO priceVO = new OrderPriceVO();
        priceVO.setGoodsAmount(BigDecimal.ZERO);
        priceVO.setOrderAmount(BigDecimal.ZERO);
        priceVO.setRealAmount(BigDecimal.ZERO);
        return priceVO;
    }

    /**
     * 计算价格
     * @param detail
     */
    public void handleCalculate(Detail detail) {
        OrderPriceVO opv = calculatePrice(detail);
        BeanUtil.copyProperties(opv, detail.getOrder());
        BeanUtil.copyProperties(opv, detail);
    }

}
