package com.xxfc.platform.vehicle.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.github.wxiaoqi.security.auth.client.annotation.IgnoreUserToken;
import com.xxfc.platform.vehicle.biz.SysRegionBiz;
import com.xxfc.platform.vehicle.common.BaseController;
import com.xxfc.platform.vehicle.common.CustomIllegalParamException;
import com.xxfc.platform.vehicle.common.RestResponse;
import com.xxfc.platform.vehicle.constant.ResCode.ResCode;
import com.xxfc.platform.vehicle.entity.SysRegion;
import lombok.extern.slf4j.Slf4j;
import org.assertj.core.util.Arrays;
import org.springframework.web.bind.annotation.*;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.weekend.WeekendSqls;

import java.util.List;

@RestController
@RequestMapping("/sysRegion")
@IgnoreClientToken
@Slf4j
public class SysRegionController extends BaseController<SysRegionBiz> {


    /**
     * 父类id获取子类对象
     * @param id
     * @return
     */
    @IgnoreUserToken
    @RequestMapping(value ="/sons/{id}",method = RequestMethod.GET)
    public RestResponse<List<SysRegion>> getSonRegion(@PathVariable Long id){
        return RestResponse.data(baseBiz.getSonRegion(id));
    }

    /**
     * 通过属性获取省
     * @param type
     * @return
     */
    @IgnoreUserToken
    @RequestMapping(value ="/getSonRegionByType/{type}",method = RequestMethod.GET)
    public RestResponse<List<SysRegion>> getSysRegionByType(@PathVariable Integer type){
        return RestResponse.data(baseBiz.getSysRegionByType(type));
    }


    @RequestMapping(value ="",method = RequestMethod.GET)
    public RestResponse<List<SysRegion>> getRegion(@RequestParam String idListJson){
        try {
            List<Long> ids = JSON.parseArray(idListJson,Long.class);
            return RestResponse.data(baseBiz.getRegionsByCodes(ids));
        } catch (JSONException ex) {
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        } catch (CustomIllegalParamException ex){
            return RestResponse.code(ResCode.INVALID_REST_REQ_PARAM.getCode());
        }
    }


    /**
     * 根据多个id查找省份
     * @param ids
     * @return
     */
    @GetMapping("/getSysRegionByIds/{ids}")
    public RestResponse getSysRegionByIds(@PathVariable String ids){
        Example exam = Example.builder(SysRegion.class)
                .where(WeekendSqls.<SysRegion>custom()
                        .andIn(SysRegion::getId, Arrays.asList(ids.split(",")))).build();
        return RestResponse.suc( baseBiz.selectByExample(exam));

    }

    /**
     * 根据一个id获取城市
     * @param id
     * @return
     */
    @GetMapping("/getSysRegionById/{id}")
    public RestResponse getSysRegionById(@PathVariable Integer id){
        Example exam = Example.builder(SysRegion.class)
                .where(WeekendSqls.<SysRegion>custom()
                        .andEqualTo(SysRegion::getId,id)).build();
        List<SysRegion> sysRegions = baseBiz.selectByExample(exam);
        if (sysRegions==null||sysRegions.size()!=1) {
            RestResponse.suc();
        }
        return RestResponse.suc( sysRegions.get(0));

    }


}
