package com.xxfc.platform.order.biz;

import cn.hutool.core.bean.BeanUtil;
import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.order.contant.enumerate.OrderStatusEnum;
import com.xxfc.platform.order.entity.BaseOrder;
import com.xxfc.platform.order.entity.OrderTourDetail;
import com.xxfc.platform.order.mapper.OrderTourVerificationMapper;
import com.xxfc.platform.order.pojo.order.OrderTourVerificationVO;
import com.xxfc.platform.tour.feign.TourFeign;
import com.xxfc.platform.tour.vo.TourGoodOrderFindVo;
import com.xxfc.platform.vehicle.entity.BranchCompany;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 旅游订单核销
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-06 18:18:33
 */
@Service
public class OrderTourVerificationBiz{


    @Autowired
    private OrderTourVerificationMapper verificationMapper;
    @Autowired
    private BaseOrderBiz baseOrderBiz;
    @Autowired
    private OrderTourDetailBiz tourDetailBiz;
    @Autowired
    private TourFeign tourFeign;

    /**
     * 分页查询旅游订单核销列表
     * @param page
     * @param limit
     * @return
     */
    public PageDataVO<OrderTourVerificationVO> getVerificationList(Integer page, Integer limit,Integer verificationId){

        return  PageDataVO.pageInfo(page,limit,()->verificationMapper.pageByParm(verificationId));
    }

    //核销
    public ObjectRestResponse VerificationByOrder(String no, List<BranchCompany> list, UserDTO userDTO){
        BaseOrder baseOrder=new BaseOrder();
        baseOrder.setNo(no);
         baseOrder=baseOrderBiz.selectOne(baseOrder);
        if(baseOrder==null){
            return ObjectRestResponse.createFailedResult(ResultCode.NULL_CODE, "订单不存在");
        }
        if(baseOrder.getStatus()!=OrderStatusEnum.ORDER_TOSTART.getCode()){
            return ObjectRestResponse.createFailedResult(ResultCode.NULL_CODE, "订单不是已支付状态");
        }
       Integer orderId=baseOrder.getId();
        Integer version=baseOrder.getVersion();
        OrderTourDetail tourDetail=new OrderTourDetail();
        tourDetail.setOrderId(orderId);
        tourDetail=tourDetailBiz.selectOne(tourDetail);
        if(tourDetail==null){
            return ObjectRestResponse.createFailedResult(ResultCode.NULL_CODE, "订单不存在");
        }
        Integer verificationId=tourDetail.getVerificationId();
        Integer total_number=tourDetail.getTotalNumber();
        if(userDTO.getDataAll()==2){
            Integer companyId=tourDetail.getStartCompanyId();
            if(companyId!=null){
                boolean falg=isPower(list,companyId);
                if(!falg){
                    return ObjectRestResponse.createFailedResult(ResultCode.FAILED_CODE, "无权限操作");
                }
            }
        }
        baseOrder=new BaseOrder();
        baseOrder.setId(orderId);
        baseOrder.setStatus(OrderStatusEnum.ORDER_FINISH.getCode());
        baseOrder.setVersion(version);
        baseOrderBiz.updateSelectiveById(baseOrder);
        tourDetail.setVerificationUser(userDTO.getId());
        tourDetail.setVerificationName(userDTO.getName());
        tourDetail.setVerificationTime(System.currentTimeMillis());
        tourDetailBiz.updateSelectiveById(tourDetail);
        tourFeign.updateTourGoodPersonNum(verificationId,"verification_person",total_number);
         return  ObjectRestResponse.succ();
    }

    //确定上车
    public ObjectRestResponse finishByOrder(Integer verificationId){

        return  ObjectRestResponse.succ(tourFeign.updateTourGoodVerificationStatus(verificationId));
    }

    //核销列表
    public ObjectRestResponse getVerifications(TourGoodOrderFindVo tourGoodOrderFindVo){

        return  ObjectRestResponse.succ(tourFeign.findTourGoodOrders(tourGoodOrderFindVo));
    }

    public  boolean isPower(List<BranchCompany> list,Integer companyId){
        boolean falg=false;
        if(list.size()>0){
            for (BranchCompany company:list) {
                if(company.getId()==companyId){
                    falg=true;
                    break;
                }

            }
        }
        return  falg;
    }





}