package com.xxfc.platform.app.biz;

import com.github.wxiaoqi.security.common.util.EntityUtils;
import org.springframework.stereotype.Service;

import com.xxfc.platform.app.entity.Cofig;
import com.xxfc.platform.app.mapper.CofigMapper;
import com.github.wxiaoqi.security.common.biz.BaseBiz;

import java.util.List;

/**
 * 系统配置表
 *
 * @author zjw
 * @email nishijjo@qq.com
 * @date 2019-06-03 15:57:13
 */
@Service
public class CofigBiz extends BaseBiz<CofigMapper,Cofig> {

    public List<Cofig> getConfigByType(List<Integer> list){
        return  mapper.getAllByType(list);

    }

    /**
     * 修改配置
     * @param cofig
     * @return
     */
    public int updateConfig(Cofig cofig) {
        EntityUtils.setUpdatedInfo(cofig);
       return mapper.updateConfig(cofig);
    }
}