package com.xinxincaravan.caravan.vehicle.constant;

import com.google.common.collect.Maps;

import java.util.Map;

public enum  ConstantType {
    VEHICLE_BRAND(1,"车辆品牌"),
    VEHICLE_USE(2,"车辆用途"),
    INSURANCE_COMPANY(3,"保险公司"),
    ZONE(4,"片区"),
    ;

    /**
     * 编码
     */
    private Integer code;
    /**
     * 类型描述
     */
    private String desc;

    private static Map<Integer,String> codeAndDesc = Maps.newHashMap();

    static{
        for(ConstantType constantType :ConstantType.values()){
            codeAndDesc.put(constantType.getCode(),constantType.getDesc());
        }
    }

    ConstantType(Integer code,String desc){
        this.code=code;
        this.desc=desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public static Boolean exists(Integer code){
        return codeAndDesc.containsKey(code);
    }

}
