package com.github.wxiaoqi.security.admin.rest;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.github.wxiaoqi.security.admin.biz.AppUserRelationBiz;
import com.github.wxiaoqi.security.admin.entity.AppUserRelation;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("relation")
public class AppUserRelationController extends BaseController<AppUserRelationBiz,AppUserRelation> {


    @RequestMapping(value = "app/unauth/small/share",method = RequestMethod.GET)
    @ApiModelProperty("小程序分享绑定")
    public ObjectRestResponse share(
            @RequestParam(value = "userid",defaultValue = "0")Integer userid,
            @RequestParam(value = "pid",defaultValue = "0")Integer pid,
            @RequestParam(value = "platform_userid",defaultValue = "0")Integer platform_userid
    ){
        return baseBiz.shareParentByUserId(userid,pid,platform_userid);
    }

}