package com.xxfc.platform.im.rest.admin;

import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.im.biz.CustomerServiceBiz;
import com.xxfc.platform.im.biz.CustomerServiceMGBiz;
import com.xxfc.platform.im.biz.UserBiz;
import com.xxfc.platform.im.dto.CustomerServiceDTO;
import com.xxfc.platform.im.vo.CustomerServiceVO;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/9/5 10:32
 */
@RestController
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
@RequestMapping("/admin/customer_service")
public class CustomerServiceAdminController {

     private final CustomerServiceMGBiz customerServiceMGBiz;

     private final CustomerServiceBiz customerServiceBiz;

     private final UserBiz userBiz;

     @GetMapping("/page")
     public ObjectRestResponse<PageDataVO<CustomerServiceVO>> findCustomerServiceWithPage(@RequestParam(value = "page") Integer page,
                                                                                          @RequestParam(value = "limit") Integer limit) {
        PageDataVO<CustomerServiceVO> pageDataVO =  customerServiceBiz.findCustomerServiceWithPage(page,limit);
        return ObjectRestResponse.succ(pageDataVO);
     }

     @GetMapping("/{id}")
     public ObjectRestResponse<CustomerServiceDTO> findCustomerService(@PathVariable(value = "id") Long id){
         CustomerServiceDTO customerServiceDTO = customerServiceBiz.findCustomerServiceById(id);
         return ObjectRestResponse.succ(customerServiceDTO);
     }

     @PostMapping("/add")
     public ObjectRestResponse<Void> addCustomerService(@RequestBody CustomerServiceDTO customerServiceDTO){
//          customerServiceMGBiz.addCustomerService(customerServiceDTO);
          customerServiceBiz.addCustomerService(customerServiceDTO);
          return ObjectRestResponse.succ();
     }

     @PutMapping("/update_password/{telphone}/{password}")
     public ObjectRestResponse<Void> updateCustomerService(@PathVariable(value = "telphone") String telphone,
                                                           @PathVariable(value = "password") String password){
          userBiz.updatePasswordByPhone(telphone,password);
          customerServiceBiz.updatePasswordByPhone(telphone,password);
          return ObjectRestResponse.succ();
     }

     @DeleteMapping("/delete/{id}/{imUserId}")
     public ObjectRestResponse<Void> deleteCustomerService(@PathVariable(value = "id") Long id,
                                                           @PathVariable(value = "imUserId") Integer imUserId){
//          customerServiceMGBiz.updateCustomerServiceIsDelToTrue(id,imUserId);
          customerServiceBiz.updateCustomerServiceIsDelToTrue(id,imUserId);
          return ObjectRestResponse.succ();
     }
}
