package com.xxfc.platform.summit.controller;

import com.alibaba.druid.sql.visitor.functions.If;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.rest.BaseController;
import com.xxfc.platform.summit.biz.ActivityBiz;
import com.xxfc.platform.summit.entity.Activity;
import com.xxfc.platform.summit.pojo.ActivityQuery;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author Administrator
 */
@RestController
@RequestMapping("/activity")
@Api(tags = "峰会")
public class ActivityController extends BaseController<ActivityBiz, Activity> {


    @PostMapping("/app/unauth/list")
    @ApiOperation(value = "峰会列表",notes = "峰会列表")
    public ObjectRestResponse getList(@RequestBody ActivityQuery query ){
        PageInfo<Activity> info= baseBiz.getList(query);
        List<Activity> list =  info.getList();
        if (query.getType()==1) {
            for (Activity activity : list) {
                if (activity.getStatus()==0){
                    long millis = System.currentTimeMillis();
                    Long startTime = activity.getStartTime();
                    Long endTime = activity.getEndTime();
                    if (millis< startTime) {
                        activity.setStatus(1);
                    }
                    if (millis>=startTime&&millis<=endTime){
                        activity.setStatus(2);
                    }
                    if (millis>endTime){
                        activity.setStatus(3);
                    }
                }
            }
        }
        return ObjectRestResponse.succ(info);
    }

    @Override
    @PutMapping ("/update")
    @ApiOperation(value = "修改",notes = "修改")
    public ObjectRestResponse update(@RequestBody Activity activity ){
        if (baseBiz.update(activity)) {
            return ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createDefaultFail();
    }

    @Override
    @PostMapping("/add")
    @ApiOperation(value = "添加",notes = "添加")
    public ObjectRestResponse add(@RequestBody Activity activity ){
        if (baseBiz.add(activity)) {
            return ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createDefaultFail();
    }


    @DeleteMapping("/remove/{id}")
    @ApiOperation(value = "删除",notes = "删除")
    public ObjectRestResponse remove(@PathVariable Integer id ){
        if (baseBiz.remove(id)) {
            return ObjectRestResponse.succ();
        }
        return ObjectRestResponse.createDefaultFail();
    }
}
