package com.xxfc.platform.order.biz;

import com.alibaba.fastjson.JSON;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.order.entity.DailyMembersOrderStatistics;
import com.xxfc.platform.order.entity.DailyVehicleOrderStatistics;
import com.xxfc.platform.order.mapper.DailyVehicleOrderStatisticsMapper;
import com.xxfc.platform.order.pojo.DedDetailDTO;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.interceptor.TransactionAspectSupport;

import java.math.BigDecimal;
import java.util.*;

/** 每日租车订单统计
 * @author Administrator
 */
@Service
public class DailyVehicleOrderStatisticsBiz extends BaseBiz<DailyVehicleOrderStatisticsMapper, DailyVehicleOrderStatistics> {

    private final Integer TYPE_DEFERRED = 1;
    private final Integer TYPE_DAMAGE = 2;


    @Transactional(rollbackFor = Exception.class)
    public boolean StatisticsOfCarRentalOrders()  {

        try {
            HashMap<String, Object> resultMap = new HashMap<>();
//        获取每日租车订单成交金和押金总额
            Map<String, BigDecimal> gmvAndMarginTotal = mapper.getGmvAndMarginTotal();
            resultMap.putAll(gmvAndMarginTotal);
//        获取车辆
            BigDecimal penalSum = mapper.getPenalSum();
            resultMap.put("penalSum", penalSum);
//        获取订单退还押金总额
            BigDecimal refundSecurityDeposit = mapper.getRefundSecurityDeposit();
            resultMap.put("refundSecurityDeposit", refundSecurityDeposit);
            //      获取违章查询总和
            BigDecimal violationMoney = mapper.getViolationMoney();
            resultMap.put("violationMoney", violationMoney);
//       获取赔偿和延期JSON字符串
            List<String> compensationAndPostpone = mapper.getCompensationAndPostpone();
//       获取赔偿和延期JSON字符串转换为map
            Map<String, BigDecimal> cpMap = getCompensationAndPostponeMap(compensationAndPostpone);
            resultMap.putAll(cpMap);
            DailyVehicleOrderStatistics orderStatistics = new DailyVehicleOrderStatistics();
            BeanUtils.copyProperties(orderStatistics,resultMap);
            insertSelective(orderStatistics);
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            return false;
        }

    }


    /**
     * 获取赔偿总额和延期总额
     */
    private Map<String, BigDecimal> getCompensationAndPostponeMap(List<String> compensationAndPostpone) {
        if (CollectionUtils.isNotEmpty(compensationAndPostpone)) {
            List<DedDetailDTO> sumDedDetailDTOs = new ArrayList<>();
            for (String value : compensationAndPostpone) {
                List<DedDetailDTO> dedDetailDTOS = JSON.parseArray(value, DedDetailDTO.class);
                sumDedDetailDTOs.addAll(dedDetailDTOS);
            }
//            获取赔偿金额总和
            BigDecimal compensation = get(sumDedDetailDTOs, TYPE_DAMAGE);
//            获取延期金额总和
            BigDecimal postpone = get(sumDedDetailDTOs, TYPE_DEFERRED);
            Map<String, BigDecimal> resultMap = new HashMap<>();
            resultMap.put("compensation", compensation);
            resultMap.put("postpone", postpone);
            return resultMap;
        }
        return new HashMap<String, BigDecimal>();
    }

    /**
     * 根据type获取对应的金额总和
     *
     * @param sumDedDetailDTOs
     * @param TYPE_DAMAGE
     * @return
     */
    private BigDecimal get(List<DedDetailDTO> sumDedDetailDTOs, Integer TYPE_DAMAGE) {
        if (CollectionUtils.isNotEmpty(sumDedDetailDTOs)) {
            BigDecimal aggregateAmount = sumDedDetailDTOs.stream()
                    .filter(d -> TYPE_DAMAGE.equals(d.getType()))
                    .map(DedDetailDTO::getCost)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            return aggregateAmount;
        }
        return null;
    }


    @Override
    public int insertSelectiveRe(DailyVehicleOrderStatistics entity) {
        Date date = new Date();
        entity.setCrtTime(new Date());
        return mapper.insertSelective(entity);
    }

}
