package com.xxfc.platform.vehicle.biz;


import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.github.wxiaoqi.security.common.util.process.ResultCode;
import com.github.wxiaoqi.security.common.vo.PageDataVO;
import com.xxfc.platform.vehicle.entity.*;
import com.xxfc.platform.vehicle.mapper.VehicleUserReserveMapper;
import com.xxfc.platform.vehicle.pojo.dto.VehicleUserReserveDTO;
import com.xxfc.platform.vehicle.pojo.vo.VehicleUserReserveVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;



@Service
@Slf4j
public class VehicleUserReserveBiz extends BaseBiz<VehicleUserReserveMapper, VehicleUserReserve>  {


    //获取列表
    public ObjectRestResponse getList(VehicleUserReserveDTO reserveDTO,Integer userId){
        Integer page=1;
        Integer limit=10;
        if (reserveDTO.getPage()!=null&&reserveDTO.getPage()>0){
            page=reserveDTO.getPage();
        }
        if (reserveDTO.getLimit()!=null&&reserveDTO.getLimit()>0){
            limit=reserveDTO.getLimit();
        }
        return  ObjectRestResponse.succ(PageDataVO.pageInfo(page, limit, ()->mapper.getList(reserveDTO,userId)));
    }

    //新增预定
    public ObjectRestResponse updReserve(VehicleUserReserveVo reserveVo){
        if (reserveVo==null){
            return  ObjectRestResponse.createFailedResult(ResultCode.NULL_CODE,"参数不能为空");
        }
        VehicleUserReserve userReserve=new VehicleUserReserveVo();
        BeanUtils.copyProperties(reserveVo,userReserve);
        insertSelective(userReserve);
        return  ObjectRestResponse.succ();
    }
}
