package com.xxfc.platform.order.pojo.dto;

import com.github.wxiaoqi.security.common.enumconstant.LevelEnum;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/11/13 15:58
 */
@Data
@Builder(toBuilder = true)
@AllArgsConstructor
@NoArgsConstructor
public class OrderDTO {
    private Integer  id;
    private Integer type;
    private Integer status;
    private BigDecimal orderAmount;
    private BigDecimal realAmount;
    private Integer orderOrigin;
    private Integer payWay;
    private Date crtTime;
    private Integer companyId;
    private String stateGroup;
    private Integer hasPay;
    /**
     * 会员相关
     */
    private Integer memberLevel;

    private LevelEnum levelEnum;


    public LevelEnum getLevelEnum(){
        return LevelEnum.getLevelEnumByLevel(this.memberLevel);
    }

}
