package com.xxfc.platform.order.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/11/11 15:49
 */
@Data
public class OrderReceivedStatisticsBase  {
    /**
     *
     */
    @Id
    @GeneratedValue(generator = "JDBC")
    @ApiModelProperty("")
    protected Long id;

    /**
     * 年份
     */
    @Column(name = "year")
    @ApiModelProperty(value = "年份")
    protected String year;

    /**
     * 月份
     */
    @Column(name = "month")
    @ApiModelProperty(value = "月份----->201908")
    protected String month;

    /**
     * 年月日
     */
    @Column(name = "date")
    @ApiModelProperty(value = "年月日")
    protected Date date;

    /**
     * 1周年的第几周
     */
    @Column(name = "week_of_year")
    @ApiModelProperty(value = "1周年的第几周--->201922")
    protected String weekOfYear;

    /**
     * 订单总额
     */
    @Column(name = "total_amount")
    @ApiModelProperty(value = "订单总额")
    protected BigDecimal totalAmount;

    /**
     * 订单总量
     */
    @Column(name = "total_quantity")
    @ApiModelProperty(value = "订单总量")
    private Integer totalQuantity;

    @Column(name = "has_pay")
    @ApiModelProperty(value = "是否支付 1已经支付 0未支付")
    protected Integer hasPay;

    /**
     * '支付来源 1--app；2--小程序',
     */
    @Column(name = "order_origin")
    @ApiModelProperty(value = " '支付来源 1--app；2--小程序',")
    protected Integer orderOrigin;

    /**
     * 支付方式 '1:微信公众号支付 2.支付宝即时到账,3,银联'
     */
    @Column(name = "pay_way")
    @ApiModelProperty(value = "支付方式 '1:微信公众号支付 2.支付宝即时到账,3,银联'")
    protected Integer payWay;

    @Column(name = "company_id")
    @ApiModelProperty(value = "分公司id")
    protected Integer companyId;

    @Transient
    protected Integer divisor;

    /**
     * 创建时间
     */
    @Column(name = "crt_time")
    @ApiModelProperty(value = "创建时间", hidden = true)
    private Date crtTime;
}
