package com.xxfc.platform.order.contant.enumerate;

import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import com.xxfc.platform.order.entity.OrderReceivedStatisticsBase;
import org.apache.commons.collections4.CollectionUtils;
import org.assertj.core.util.Lists;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/11/14 14:28
 */
public enum  StatisticsStatusEnum {
    ;
    public static final int FINISH = 6;
    public static final int CANCEL = 2;
    public static final int UNFINISH = 3;
    public static final int DEFAULT_COMPANY=1;
    public static final int ORDER_MEMBER_TYPE=3;
    public static final int ORDER_RENT_VEHICLE_TYPE=1;
    public static final int ORDER_TOUR_TYPE=2;
    public static final String UN_PAY_STATE="0";
    public static final int NO_PAY_WAY=99;

    public static List<String> orderStates;
    public static List<String> orderOrigins;
    public static List<String> orderPayWays;

    static {
         // 0 未支付 1 已支付
        orderStates = Lists.newArrayList("0","1");
        // 1 app   2 小程序  3 其他
        orderOrigins = Lists.newArrayList("1","2","3");
        // 1 微信  2 支付宝
        orderPayWays = Lists.newArrayList("1","2");
    }

    public static List<String> statisticsSateGroupWithCompanys(List<Integer> companyIdList){
        List<String> orderStatisticsStateGroups = new ArrayList<>();
        List<String> stateGroup = statisticsStateGroup();
        for (String stgp : stateGroup) {
            for (Integer companyId : companyIdList) {
                 // 公司id-订单来源-支付方式-订单状态
                orderStatisticsStateGroups.add(String.format("%d-%s",companyId,stgp));
            }
        }
        return orderStatisticsStateGroups;
    }

    public static List<String> statisticsStateGroup(){
        List<String> orderStatisticsStateGroups = new ArrayList<>();
        for (String orderOrigin : orderOrigins) {
            for (String orderPayWay : orderPayWays) {
                for (String orderState : orderStates) {
                    //订单来源-支付方式-订单状态
                    orderStatisticsStateGroups.add(String.format("%s-%s-%s",orderOrigin,orderState==UN_PAY_STATE?String.valueOf(NO_PAY_WAY):orderPayWay,orderState));
                }
            }
        }
        return orderStatisticsStateGroups;
    }
    public static List<String> getOtherStatisticsStateGroup(List<Integer> companyIdList,List<String> statisticsStates){
        List<String> stateGroupList = CollectionUtils.isEmpty(companyIdList)?statisticsStateGroup():statisticsSateGroupWithCompanys(companyIdList);
        stateGroupList.removeAll(statisticsStates);
        return stateGroupList;
    }

    public static<T extends OrderReceivedStatisticsBase> T wrapStatisticsObject(Date date,String stateGroup,T targetObj){
        DateTime yesterday = DateTime.of(date);
        String year = String.valueOf(yesterday.getField(DateField.YEAR));
        String month = String.format("%s%d", year, yesterday.getField(DateField.MONTH));
        String weekOfYear = String.format("%s%d", year, yesterday.getField(DateField.WEEK_OF_YEAR));
        String[] status = stateGroup.split("-");
        targetObj.setCrtTime(new Date());
        targetObj.setCompanyId(Integer.valueOf(status[0]));
        targetObj.setHasPay(Integer.valueOf(status[3]));
        targetObj.setOrderOrigin(Integer.valueOf(status[1]));
        targetObj.setPayWay(Integer.valueOf(status[2]));
        targetObj.setDate(date);
        targetObj.setYear(year);
        targetObj.setMonth(month);
        targetObj.setWeekOfYear(weekOfYear);
        return targetObj;
    }
}
