package com.github.wxiaoqi.security.common.enumconstant;

import java.util.EnumSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/11/13 17:23
 */
public enum LevelEnum {
    DIAMOND(3,"钻石"),
    GOLD(2,"黄金"),
    GENERAL(1,"普通");

    LevelEnum(Integer level, String desc) {
        this.level = level;
        this.desc = desc;
    }


    public static LevelEnum getLevelEnumByLevel(Integer level){
        return levelMap.get(level);
    }

    private Integer level;
    private String desc;
    private static  Map<Integer, LevelEnum> levelMap;

    static {
        levelMap = EnumSet.allOf(LevelEnum.class).stream().collect(Collectors.toMap(LevelEnum::getLevel, Function.identity()));
    }

    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}

