package com.xinxincaravan.caravan.vehicle.rest;

import com.github.wxiaoqi.security.auth.client.annotation.IgnoreClientToken;
import com.xinxincaravan.caravan.vehicle.biz.VehicleDepartureService;
import com.xinxincaravan.caravan.vehicle.common.RestResponse;
import com.xinxincaravan.caravan.vehicle.constant.ResCode.ResCode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@IgnoreClientToken
@RestController
@RequestMapping("departure")
public class VehicleDepartureController {

    @Autowired
    VehicleDepartureService vehicleDepartureService;

    @GetMapping("page")
    public RestResponse page(String numberPlate, Integer page, Integer limit) {
        if (page == null || limit == null) {
            page = 1;
            limit = 10;
        }
        return RestResponse.suc(vehicleDepartureService.page(numberPlate, page, limit));
    }

    @GetMapping("findByVehicle")
    public RestResponse findByVehicle(String vehicleId, Integer page, Integer limit) {
        if (vehicleId == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        if (page == null || limit == null) {
            page = 1;
            limit = 10;
        }
        return RestResponse.suc(vehicleDepartureService.findByVehicle(vehicleId, page, limit));
    }

    @GetMapping("statistic")
    public RestResponse statistic(String numberPlate) {
        if (numberPlate == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        return RestResponse.suc(vehicleDepartureService.statistic(numberPlate));
    }


}
