package com.xinxincaravan.caravan.vehicle.rest;

import com.xinxincaravan.caravan.vehicle.biz.VehicleActiveService;
import com.xinxincaravan.caravan.vehicle.common.RestResponse;
import com.xinxincaravan.caravan.vehicle.constant.ResCode.ResCode;
import com.xinxincaravan.caravan.vehicle.vo.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;

@RestController
@RequestMapping("active")
public class VehicleActiveController {

    @Autowired
    VehicleActiveService vehicleActiveService;


    /**
     * 发车
     *
     * @return
     */
    @PostMapping("departure")
    public RestResponse departure(@RequestBody VehicleDepartureVo departureVo) {
        if (departureVo == null || departureVo.getVehicleId() == null
                || departureVo.getMileage() == null || departureVo.getDepartureBranchCompanyId() == null
                || departureVo.getExpectArrivalBranchCompanyId() == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        vehicleActiveService.departure(departureVo);
        return RestResponse.suc();
    }

    /**
     * 还车
     *
     * @param arrivalVo
     * @return
     */
    @PostMapping("arrival")
    public RestResponse arrival(@RequestBody VehicleArrivalVo arrivalVo) {
        if (arrivalVo == null || arrivalVo.getVehicleId() == null
                || arrivalVo.getMileage() == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        vehicleActiveService.arrival(arrivalVo);
        return RestResponse.suc();
    }

    /**
     * 保养
     *
     * @param vehicleUpkeepVo
     * @return
     */
    @PostMapping("upkeep")
    public RestResponse upkeep(@RequestBody VehicleUpkeepVo vehicleUpkeepVo) {
        if (vehicleUpkeepVo.getVehicleId() == null || vehicleUpkeepVo.getOperator() == null || vehicleUpkeepVo.getAmount() == null ||
                vehicleUpkeepVo.getApprovers() == null || vehicleUpkeepVo.getBranchCompanyId() == null || vehicleUpkeepVo.getMileage() == null ||
                vehicleUpkeepVo.getUpkeepItems() == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        if (vehicleUpkeepVo.getDate() == null) {
            vehicleUpkeepVo.setDate(new Date());
        }
        vehicleActiveService.upkeep(vehicleUpkeepVo);
        return RestResponse.suc();
    }

    /**
     * 保养结束
     *
     * @param vehicleUpkeepEndVo
     * @return
     */
    @PostMapping("upkeepEnd")
    public RestResponse upkeepEnd(@RequestBody VehicleUpkeepEndVo vehicleUpkeepEndVo) {
        if (vehicleUpkeepEndVo.getVehicleId() == null) {
            return RestResponse.codeAndMessage(ResCode.INVALID_REST_REQ_PARAM.getCode(),
                    ResCode.INVALID_REST_REQ_PARAM.getDesc());
        }
        vehicleActiveService.upkeepEnd(vehicleUpkeepEndVo);
        return RestResponse.suc();
    }

    /**
     * 维修
     *
     * @return
     */
    public RestResponse repair(@RequestBody VehicleRepairVo vehicleRepairVo) {

        return RestResponse.suc();
    }

    /**
     * 维修结束
     *
     * @return
     */
    public RestResponse repairEnd() {
        return RestResponse.suc();
    }

}
