package com.xinxincaravan.caravan.vehicle.mapper;

import com.xinxincaravan.caravan.vehicle.entity.Vehicle;
import com.xinxincaravan.caravan.vehicle.vo.AddOrUpdateVehicleVo;
import com.xinxincaravan.caravan.vehicle.vo.QueryVehicleVo;
import org.springframework.data.repository.query.Param;
import tk.mybatis.mapper.common.Mapper;

import java.util.List;
import java.util.Map;

public interface VehicleMapper extends Mapper<Vehicle> {

    public List<QueryVehicleVo> getByPage(Map<String,Object> params);

    public int updateStatusById(Map<String,Object> params);

    /**
     * 锁定相关编码 或 车牌 的行
     * @param addOrUpdateVehicleVo
     * @return
     */
    public List<Vehicle> lockByCode(AddOrUpdateVehicleVo addOrUpdateVehicleVo);

    int updateStatusByIdAndStatus(@Param("vehicleId") String vehicleId, @Param("status") Integer status,
                                  @Param("lastStatus") Integer lastStatus);

    Vehicle selectByNumberPlate(String numberPlate);
}