package com.xinxincaravan.caravan.vehicle.biz;

import com.ace.cache.annotation.Cache;
import com.ace.cache.annotation.CacheClear;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.google.common.collect.Lists;
import com.xinxincaravan.caravan.vehicle.common.RestResponse;
import com.xinxincaravan.caravan.vehicle.constant.RedisKey;
import com.xinxincaravan.caravan.vehicle.entity.BranchCompany;
import com.xinxincaravan.caravan.vehicle.mapper.BranchCompanyMapper;
import com.xinxincaravan.caravan.vehicle.vo.BranchCompanyVo;
import com.xinxincaravan.caravan.vehicle.vo.PageDataVo;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import tk.mybatis.mapper.entity.Example;

import java.io.File;
import java.util.List;
import java.util.concurrent.TimeUnit;

@Service
@Slf4j
public class BranchCompanyBiz extends BaseBiz<BranchCompanyMapper, BranchCompany> {

    public static final DateTimeFormatter DEFAULT_DATE_TIME_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd");
    public static final DateTimeFormatter YEARMONTH_DATE_TIME_FORMATTER = DateTimeFormat.forPattern("yyyy-MM");

    @Autowired
    private RedisTemplate customRedisTemplate;

    @Value("${branchCompanyPic.baseUploadPath}")
    private String baseUploadPath ;

    /**
     * 按主键获取公司
     * @param id
     * @return
     */
    public BranchCompany getById(Integer id){
        return mapper.selectByPrimaryKey(id);
    }

    public Boolean exits(Integer id){
        BranchCompany param = new BranchCompany();
        param.setId(id);
        return mapper.selectCount(param)>0;
    }

    /**
     * 转换为vo类
     * @param branchCompanies
     * @returns
     */
    private List<BranchCompanyVo> branchCompany2VO(List<BranchCompany> branchCompanies){
        List<BranchCompanyVo> branchCompanyVoList = Lists.newArrayList();
        if(CollectionUtils.isNotEmpty(branchCompanies)){
            for(BranchCompany branchCompany:branchCompanies){
                BranchCompanyVo branchCompanyVo = new BranchCompanyVo();
                BeanUtils.copyProperties(branchCompany,branchCompanyVo);
                branchCompanyVoList.add(branchCompanyVo);
            }
        }
        return  branchCompanyVoList;
    }

    public PageDataVo<BranchCompany> getAll(Integer page,Integer limit,Integer addrProvince, Integer addrCity,
                                             Integer addrTown){
        Example example = new Example(BranchCompany.class);
        Example.Criteria criteria = example.createCriteria();
        if(addrProvince!=null) {
            criteria.andCondition(" addr_province = '" + addrProvince + "'");
        }
        if(addrCity!=null) {
            criteria.andCondition(" addr_city = '" + addrCity + "'");
        }
        if(addrTown!=null) {
            criteria.andCondition(" addr_town = '" + addrTown + "'");
        }
        example.setOrderByClause("`id` asc");
        PageHelper.startPage(page,limit);
        PageInfo<BranchCompany> branchCompanyPageInfo = new PageInfo<>(mapper.selectByExample(example));
        return PageDataVo.pageInfo(branchCompanyPageInfo);
    }

    @Cache(key= RedisKey.BRANCH_COMPANY_CACHE_ALL)
    public List<BranchCompany> getAll(){
        return mapper.selectAll();
    }

    /**
     * 增加公司，返回id
     * @param branchCompanyVo
     * @return
     */
    @CacheClear(key= RedisKey.BRANCH_COMPANY_CACHE_ALL)
    public Integer add(BranchCompanyVo branchCompanyVo){
        BranchCompany branchCompany = new BranchCompany();
        BeanUtils.copyProperties(branchCompanyVo,branchCompany);
        mapper.insertSelective(branchCompany);
        return branchCompany.getId();
    }

    @CacheClear(key= RedisKey.BRANCH_COMPANY_CACHE_ALL)
    public void del(Integer id){
        mapper.deleteByPrimaryKey(id);
    }

    /**
     * 更新公司信息
     * @param branchCompany
     * @return
     */
    @CacheClear(key= RedisKey.BRANCH_COMPANY_CACHE_ALL)
    public Integer update(BranchCompany branchCompany){
        return mapper.updateByPrimaryKeySelective(branchCompany);
    }

    /**
     * 写入上传文件，返回相对路径
     * @param file
     * @return
     */
    public RestResponse<String> uploadCompanyPic(MultipartFile file) throws Exception{
        //创建本日存放目录
        DateTime now = DateTime.now();
        String dirPathToday =  File.separator + now.toString(DEFAULT_DATE_TIME_FORMATTER);
        String redisNoKey = RedisKey.UPLOAD_FILE_NO_PREFIX + now.toString(DEFAULT_DATE_TIME_FORMATTER);
        Long no = customRedisTemplate.opsForValue().increment(redisNoKey);
        if(no.equals(1l)){
            customRedisTemplate.expire(redisNoKey,1, TimeUnit.DAYS);
        }
        String fileName = file.getOriginalFilename();
        String realFileRelPath = dirPathToday + File.separator + no + fileName.substring(fileName.lastIndexOf("."));
        //文件存放路径
        String filePath = baseUploadPath + realFileRelPath;
        //将文件写入指定位置
        FileUtils.copyInputStreamToFile(file.getInputStream(), new File(filePath));
        return RestResponse.suc(realFileRelPath);
    }



}
