package com.xxfc.platform.order.biz;

import com.github.wxiaoqi.security.common.biz.BaseBiz;
import com.xxfc.platform.order.entity.DailyMembersOrderStatistics;
import com.xxfc.platform.order.entity.DailyTravelOrderStatistics;
import com.xxfc.platform.order.mapper.DailyMembersOrderStatisticsMapper;
import com.xxfc.platform.order.mapper.DailyTravelOrderStatisticsMapper;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 每日购买会员订单统计
 *
 * @author Administrator
 */
@Service
public class DailyMembersOrderStatisticsBiz extends BaseBiz<DailyMembersOrderStatisticsMapper, DailyMembersOrderStatistics> {


    public boolean memberOrderStatistics() {
        try {
            HashMap<String, Object> resultMap = new HashMap<>();
            Map<String, Object> travelGmv = mapper.getTravelGmv();
            resultMap.putAll(travelGmv);
            DailyMembersOrderStatistics MembersStatistics = new DailyMembersOrderStatistics();
            BeanUtils.copyProperties(MembersStatistics, resultMap);
            insertSelective(MembersStatistics);
            return true;
        } catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public int insertSelectiveRe(DailyMembersOrderStatistics entity) {
        entity.setCrtTime(new Date());
        return mapper.insertSelective(entity);
    }
}
