package com.xxfc.platform.order.pojo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;
import java.util.List;

/**
 * 总业绩查询条件
 * @author Administrator
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@ApiModel
public class QueryCriteria {

    @ApiModelProperty(value ="开始时间" )
    private Date startDate;

    @ApiModelProperty(value = "结束时间")
    private Date endDate;

    @ApiModelProperty(value = "订单类型:1-租车 2-旅游 3-会员 null-全部")
    private Integer orderType;

    @ApiModelProperty(value = "业绩所属公司")
    private Integer companyId;

    @ApiModelProperty(value = "支付方式: 1-微信支付 2-支付宝支付 3-银联支付 null-全部")
    private Integer paymentMethod;

    @ApiModelProperty(value = "账目类型:  0-入账 1-出账")
    private Integer type = 0;

    @ApiModelProperty("权限公司id")
    private List<Integer>  jurisdiction;

    @ApiModelProperty(value = "当前页数")
    private Integer page=1;

    @ApiModelProperty(value = "每页条数")
    private Integer limit=10;
 }

