package com.xxfc.platform.vehicle.rest.admin;

import com.github.wxiaoqi.security.admin.feign.dto.UserDTO;
import com.github.wxiaoqi.security.common.msg.ObjectRestResponse;
import com.xxfc.platform.vehicle.biz.VehicleModelHolidayPriceBiz;
import com.xxfc.platform.vehicle.pojo.dto.VehicleModelHolidayPriceFindDTO;
import com.xxfc.platform.vehicle.pojo.dto.VehicleModelHolidayPriceSaveDTO;
import com.xxfc.platform.vehicle.pojo.vo.VehicleModelHolidayPriceVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author libin
 * @version 1.0
 * @description
 * @data 2019/10/14 17:35
 */
@RestController
@RequestMapping("/admin/vehicle_model/holiday_price")
@RequiredArgsConstructor(onConstructor = @__(@Autowired))
@Api(tags = "节假日设置")
public class VehicleModelHolidayPriceAdminController {
    private final VehicleModelHolidayPriceBiz vehicleModelHolidayPriceBiz;

    @ApiOperation("节假日添加|设置")
    @PostMapping("/add_edit")
    public ObjectRestResponse<Void> add(@RequestBody VehicleModelHolidayPriceSaveDTO vehicleModelHolidayPriceSaveDTO, UserDTO userDTO) {
        vehicleModelHolidayPriceBiz.addVehicleModelHolidayPrice(vehicleModelHolidayPriceSaveDTO, userDTO.getId());
        return ObjectRestResponse.succ();
    }

    @GetMapping("/{id}")
    public ObjectRestResponse<VehicleModelHolidayPriceSaveDTO> findVehicleModelHolidayPrice(@PathVariable(value = "id") Long id){
        VehicleModelHolidayPriceSaveDTO  vehicleModelHolidayPriceSaveDTO = vehicleModelHolidayPriceBiz.findVehicleModelHolidayPriceById(id);
        return ObjectRestResponse.succ(vehicleModelHolidayPriceSaveDTO);
    }

    @ApiOperation("节假日页查询")
    @PostMapping("/page")
    public ObjectRestResponse<List<VehicleModelHolidayPriceVo>> listVehicleModelHolidayPrice(@RequestBody VehicleModelHolidayPriceFindDTO vehicleModelHolidayPriceFindDTO){
        List<VehicleModelHolidayPriceVo> priceVoPageDataVO = vehicleModelHolidayPriceBiz.listVehicleModelHolidayPrice(vehicleModelHolidayPriceFindDTO);
        return ObjectRestResponse.succ(priceVoPageDataVO);
    }
}
